﻿using UnityEngine;
using System.Collections;

public class ScoreListener : MonoBehaviour
{
    protected virtual void OnEnable()
    {
        Messenger.AddListener<int>(Message.eScoreUpdated, OnScoreUpdated);
    }

    protected virtual void OnDisable()
    {
        Messenger.RemoveListener<int>(Message.eScoreUpdated, OnScoreUpdated);
    }

    protected virtual void OnScoreUpdated(int newScore)
    {
    }
}