﻿using UnityEngine;
using System.Collections;

public class MainMenuEyes : MonoBehaviour
{
    private Color m_Color;
    private Timer m_WaitTimer;
    private Timer m_ShowTimer;

    private Material[] m_Materials;

    void OnEnable()
    {
        m_Materials = new Material[transform.childCount];
        int i = 0;
        foreach (Transform t in transform)
        {
            m_Materials[i] = t.renderer.material;
            i++;
        }

        m_Color = m_Materials[0].color;
        m_Color.a = 0f;

        foreach (Material m in m_Materials)
        {
            m.color = m_Color;
        }
    }

    public void Appear(float wait, float show)
    {
        m_WaitTimer = new Timer(wait);
        m_ShowTimer = new Timer(show);
        StartCoroutine("C_Appear");
    }

    private IEnumerator C_Appear()
    {
        m_WaitTimer.Start();
        while (!m_WaitTimer.UpdateTime())
        {
            yield return 0;
        }

        m_ShowTimer.Start();
        while (!m_ShowTimer.UpdateTime())
        {
            m_Color.a = m_ShowTimer.GetHermiteProgress() * 2f;
            foreach (Material m in m_Materials)
            {
                m.color = m_Color;
            }
            yield return 0;
        }
    }
}