﻿using UnityEngine;
using System.Collections;

public class StartButton : MonoBehaviour
{
    public Texture2D[] m_PopupTexture;
    public Texture2D[] m_PopupLoopTexture;

    private Popup m_Popup;
    private int m_CurrentPopup;
    private bool m_Loop;
    private bool m_PopupActive;

    private TextBuilder m_TextTime;
    private TextBuilder m_TextClic;

    private int m_ClicCounter;
    private float m_InitialTime;

    private bool m_Achievement;

    void OnEnable()
    {
        m_CurrentPopup = 0;
        m_Loop = false;
        m_Popup = GetComponent<Popup>();
        m_PopupActive = false;
        ChangeTexture();
        m_TextClic = GameObject.Find(name + "/TextClic").GetComponent<TextBuilder>();
        m_TextTime = GameObject.Find(name + "/TextTime").GetComponent<TextBuilder>();
        m_ClicCounter = 0;
        m_InitialTime = Time.time;
        m_Achievement = false;
    }

    void Update()
    {
        if (InputManager.Instance.GetMouseClic(0))
        {
            m_ClicCounter++;
        }

        // Popup showed
        if (m_PopupActive)
        {
            // Popup inactivate (button OK pushed)
            if (!m_Popup.IsActive)
            {
                if (m_Loop)
                {
                    if (m_CurrentPopup == 1)
                    {
                        m_TextClic.HideText();
                    }
                    else if (m_CurrentPopup == 2)
                    {
                        m_TextTime.HideText();
                    }
                }
                ChangeTexture();
                m_PopupActive = false;
            }
        }
        // Popup hidden
        else
        {
            if (m_Popup.IsActive)
            {
                if (m_Loop)
                {
                    if (m_CurrentPopup == 1)
                    {
                        m_TextClic.SetText(m_ClicCounter.ToString());
                        m_TextClic.DisplayText();
                        if (!m_Achievement)
                        {
                            GameManager.Instance.EarnPoints(50);
                            m_Achievement = true;
                        }
                    }
                    else if (m_CurrentPopup == 2)
                    {
                        m_TextTime.SetText(((int)(Time.time - m_InitialTime) / 60).ToString());
                        m_TextTime.DisplayText();
                    }
                }
                m_PopupActive = true;
            }
        }
    }

    private void ChangeTexture()
    {
        if (m_Loop)
        {
            m_Popup.m_Message[0] = m_PopupLoopTexture[m_CurrentPopup];
            m_CurrentPopup = (m_CurrentPopup + 1) % m_PopupLoopTexture.Length;
        }
        else
        {
            m_Popup.m_Message[0] = m_PopupTexture[m_CurrentPopup];
            m_CurrentPopup++;
            if (m_CurrentPopup == m_PopupTexture.Length)
            {
                m_CurrentPopup = 0;
                m_Loop = true;
            }
        }
    }
}