﻿using UnityEngine;
using System.Collections;

public class IELoading : StoryEvent
{
    public Texture2D[] m_Screens;

    void Start()
    {
        renderer.enabled = false;
    }

    public override void StartStory()
    {
        renderer.enabled = true;
        StartCoroutine("C_IELoading");
    }

    private IEnumerator C_IELoading()
    {
        foreach (Texture2D tex in m_Screens)
        {
            renderer.material.SetTexture("_MainTex", tex);
            yield return new WaitForSeconds(1.5f);
        }
        Debug.Log("Loading end");
        m_Finished = true;
    }
}