﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class CheckPoint : MonoBehaviour
{
    public int m_Points;
    public int Points
    {
        get { return m_Points; }
    }

    private int m_Order;
    public int Order
    {
        get { return m_Order; }
    }
    public int m_StoryStep;
    public int StoryStep
    {
        get { return m_StoryStep; }
    }
    public InteractTrigger m_Trigger;
    public Transform m_SpawnPoint;
    public Vector3 Position
    {
        get { return m_SpawnPoint.position; }
    }

    private List<int> m_CollectedItems;

    private bool m_Checked;
    private bool m_IsIn;
    private Element[] m_Elements;
    private Character[] m_Characters;

    public CheckpointModel m_Model;

    #region Initialization
    void Start()
    {
        m_Trigger = GetComponentInChildren<InteractTrigger>();
        m_Elements = GetComponentsInChildren<Element>();
        m_Characters = GetComponentsInChildren<Character>();
        m_Checked = false;
        m_IsIn = false;
        m_Order = int.Parse(name.Replace("CheckPoint", ""));
        m_CollectedItems = new List<int>();
	}

    public void SetItemsStatus(List<int> items)
    {
        if(items != null)
            m_CollectedItems = items;

        if (m_CollectedItems.Count > 0)
        {
            foreach (int id in m_CollectedItems)
            {
                foreach (Element e in m_Elements)
                {
                    if (e.ID == id)
                    {
                        Debug.Log("Deactivate " + e.name + "(id = " + e.ID + ")");
                        e.gameObject.SetActive(false);
                        e.SaveStatus();
                    }
                }
            }
        }
    }
    #endregion

    void Update()
    {
        if (!m_IsIn)
        {
            if (m_Trigger.IsIn)
            {
                if (m_Checked)
                {
                    if (m_Model != null)  m_Model.SetCurrent(true);
                }
                else
                {
                    if(m_Model != null) m_Model.Appear();
                    m_Checked = true;
                }
                m_IsIn = true;
                GameManager.Instance.NewCheckPoint(this);
            }
        }
        else
        {
            if (!m_Trigger.IsIn)
            {
                m_IsIn = false;
            }
        }
	}

    public void SetCurrent(bool current)
    {
        if (m_Model != null)  m_Model.SetCurrent(current);
    }

    public List<int> SaveProgress()
    {
        if (!m_Checked)
            return m_CollectedItems;

        // Save elements status
        int id;
        foreach (Element e in m_Elements)
        {
            if ( (id = e.SaveStatus()) >= 0)
            {
                m_CollectedItems.Add(id);
            }
        }

        // TODO : Save enemies status
        foreach (Character c in m_Characters)
        {

        }

        return m_CollectedItems;
    }

    public void UpdateProgress()
    {
        // TODO : Load elements initial (or saved) status
        foreach (Element e in m_Elements)
        {
            e.ReInit();
        }

        // Load enemies initial (or saved) status
        foreach (Character c in m_Characters)
        {
            c.ReInit();
        }
    }

    void OnDrawGizmos()
    {
        Color initColor = Gizmos.color;

        foreach (Element e in GetComponentsInChildren<Element>())
        {
            Gizmos.color = Color.green;
            Gizmos.DrawLine(m_SpawnPoint.position, e.transform.position);
        }

        foreach (Character c in GetComponentsInChildren<Character>())
        {
            Gizmos.color = Color.red;
            Gizmos.DrawLine(m_SpawnPoint.position, c.transform.position);
        }
    }
}