﻿using UnityEngine;
using System.Collections;

public class HUD : ScoreListener
{
    private int m_Score;
    private int m_Added;
    private bool m_ShowAdded;
    private Timer m_Timer;

    public GUIStyle m_Style;

    protected override void OnEnable()
    {
        base.OnEnable();
        m_Timer = new Timer(2f);
        m_Added = 0;
    }

    protected override void OnScoreUpdated(int newScore)
    {
        m_Added += newScore - (m_Score+m_Added);
        if (m_Added == 0)
        {
            m_ShowAdded = false;
            return;
        }

        m_Timer.Restart();
        if (!m_ShowAdded)
        {
            StartCoroutine("C_OnScoreUpdated");
            m_ShowAdded = true;
        }
    }

    private IEnumerator C_OnScoreUpdated()
    {
        while (!m_Timer.UpdateTime())
        {
            yield return 0;
        }

        m_ShowAdded = false;
        m_Score += m_Added;
        m_Added = 0;
    }

    void OnGUI()
    {
        if (m_ShowAdded)
        {
            if (m_Added > 0)
            {
                GUI.Label(new Rect(10, 10, 200, 30), "Score : " + m_Score + "  +" + m_Added, m_Style);
            }
            else
            {
                GUI.Label(new Rect(10, 10, 200, 30), "Score : " + m_Score + "  " + m_Added, m_Style);
            }
        }
        else GUI.Label(new Rect(10, 10, 200, 30), "Score : " + m_Score, m_Style);
    }
}