﻿using UnityEngine;
using System.Collections;

public class Level : MonoBehaviour
{
    public bool m_Music;
    protected Story m_Story;
    protected CheckPoint[] m_CheckPoints;
    public CheckPoint[] CheckPoints
    {
        get { return m_CheckPoints; }
    }

    #region Initialization
    protected virtual void Start()
    {
        m_Story = GetComponent<Story>();
        GameManager.Instance.CanPlayMusic = m_Music;
	}

    public virtual void SetStoryProgress(int state)
    {
        m_Story.InitializeProgress(state);
    }
    #endregion

    public virtual void UpdateLevel()
    {
        m_Story.UpdateStory();
	}

    #region Events
    public virtual void SaveProgress()
    {
    }

    public virtual void LoadProgress()
    {
    }

    public virtual void Lost()
    {
    }
    #endregion
}