﻿using UnityEngine;
using System.Collections;

public class StoryElement : Element
{
    public Element m_Source;
    public StoryEvent m_Story;

    private bool m_Cancel = false;

    protected override void OnEnable()
    {
        base.OnEnable();
        m_Active = false;
        StartCoroutine("C_OnEnable");
    }

    private IEnumerator C_OnEnable()
    {
        // Wait for the door init
        yield return 0;
        m_Cancel = m_Story.Initialize();
    }

    public override bool UpdateElement()
    {
        // Skip
        if (m_Cancel)
            return true;

        if (!m_Active)
        {
            if (m_Source == null || m_Source.UpdateElement())
            {
                m_Story.StartStory();
                m_Active = true;
            }
            return false;
        }
        else return m_Story.IsFinished;
    }

    public override void Show()
    {
        m_Active = true;
    }

    public override void Hide()
    {
        m_Active = false;
    }

    public override void ReInit()
    {
        Debug.Log("ReInit");
        m_Active = false;
    }

    public void Cancel()
    {
        m_Cancel = true;
    }
}