﻿using UnityEngine;
using System.Collections;

public class Button : Element
{
    public bool m_UseShortCut = false;

    public override bool UpdateElement()
    {
        if (!m_Active)
            return false;

        // Push Enter
        if (m_UseShortCut && InputManager.Instance.GetMenuInputStatus(InputSettings.MenuInputs.OK))
        {
            return true;
        }

        // Push OK button
        if (Input.GetMouseButtonDown(0))
        {
            RaycastHit hitInfo;
            if (Physics.Raycast(Camera.main.ScreenPointToRay(Input.mousePosition), out hitInfo))
            {
                if (hitInfo.transform == transform)
                {
                    return true;
                }
            }
        }

        return false;
    }

    public override void Show()
    {
        base.Show();
    }

    public override void Hide()
    {
        base.Hide();
    }
}