﻿using UnityEngine;
using System.Collections;

[RequireComponent(typeof(InteractTrigger))]
public class Teleporter : Element
{
    public Transform m_From;
    public Transform m_Destination;
    private InteractTrigger m_Trigger;

	// Use this for initialization
	protected override void Start()
    {
 	    base.Start();
        m_Active = true;
        m_Trigger = GetComponent<InteractTrigger>();
	}
	
	// Update is called once per frame
	public override bool UpdateElement()
    {
        if (m_Active && m_Trigger.IsIn)
        {
            m_Trigger.InteractCharacter.MustGoSomewhere(m_From.position, 0.4f);
            StartCoroutine("C_Teleport");
            m_Active = false;
        }
        return base.UpdateElement();
	}

    private IEnumerator C_Teleport()
    {
        m_Trigger.InteractCharacter.CharacterCanMove(false);
        yield return new WaitForSeconds(1f);
        Fade.Instance.In(0.5f);
        yield return new WaitForSeconds(0.5f);
        m_Trigger.InteractCharacter.Teleport(m_Destination.position);
        yield return new WaitForSeconds(0.5f);
        Fade.Instance.Out(0.5f);
        m_Trigger.InteractCharacter.CharacterCanMove(true);
        m_Active = true;
    }
}