﻿using UnityEngine;
using System.Collections;

public class Diode : MonoBehaviour
{
    public Color m_On;
    public Color m_Off;

    public int m_Status;
    private bool m_IsOn;
    public bool IsOn
    {
        get { return m_IsOn; }
    }

	void Start()
    {
        m_IsOn = false;
        foreach (Material m in renderer.materials)
        {
            m.color = m_Off;
        }
	}

    public void SetOn(bool on)
    {
        SetOn(m_Status, on);
    }

    public void SetOn(int status, bool on)
    {
        if (status != m_Status)
            return;

        if (on)
        {
            m_IsOn = true;
            foreach (Material m in renderer.materials)
            {
                m.color = m_On;
            }
        }
        else
        {
            m_IsOn = false;
            foreach (Material m in renderer.materials)
            {
                m.color = m_Off;
            }
        }
    }
}