﻿using UnityEngine;
using System.Collections;

public class Mine : Enemy
{
    public Color m_Good;
    public Color m_NotGood;
    private InteractTrigger m_Trigger;

    protected override void Start()
    {
        base.Start();
        // Create the character motor
        m_CharacterAnimator = gameObject.AddComponent<Hero_Animator>();
        Hero_Physic heroPhysic = new Hero_Physic(m_CharacterModel, GetComponentInChildren<CharacterController>());
        m_CharacterMotor = gameObject.AddComponent<Character_Motor>();
        m_CharacterMotor.Initialize(m_CharacterModel, m_CharacterAnimator, heroPhysic);
        m_Trigger = GetComponent<InteractTrigger>();
        renderer.material.color = m_Good;
    }

    public override void UpdateCharacter()
    {
        if (m_Trigger.IsIn)
        {
            renderer.material.color = m_NotGood;
            GameManager.Instance.Lost(-m_Dammage);
        }
    }

    public override void ReInit()
    {
        base.ReInit();
        renderer.material.color = m_Good;
    }
}