﻿using UnityEngine;
using System.Collections;

public class Lazer : Enemy
{
    // Ray sources
    public Transform m_Ray;
    public Transform m_Particles;
    private Ray m_View;

    public bool m_UseMaxRange = false;
    public float m_MaxRange;

    public bool m_ThroughAll = false;

    protected override void Start()
    {
        base.Start();
        m_View = new Ray();

        if (m_PlayImmediate) Play();
        else Stop();
    }

    public override void Play()
    {
        base.Play();
        m_Ray.gameObject.SetActive(true);
        m_Particles.gameObject.SetActive(true);
    }

    public override void Stop()
    {
        base.Stop();
        m_Ray.gameObject.SetActive(false);
        m_Particles.gameObject.SetActive(false);
    }

    // Update is called once per frame
    public override void UpdateCharacter()
    {
        if (!m_Activate)
            return;

        base.UpdateCharacter();

        // Define rays
        m_View.origin = m_Ray.position;
        m_View.direction = -m_Ray.up;

        Debug.DrawRay(m_View.origin, m_View.direction, Color.red, 0.1f);

        RaycastHit hitInfo;
        int layer = LayersUtils.HeroLayerWithOcclusion;
        if (m_ThroughAll) layer = LayersUtils.HeroLayerWithPartialOcclusion;

        if (Physics.Raycast(m_View, out hitInfo, Mathf.Infinity, layer))
        {
            if (m_UseMaxRange && hitInfo.distance > m_MaxRange)
            {
                // Define the ray length
                m_Ray.localScale = new Vector3(m_Ray.localScale.x, m_MaxRange, m_Ray.localScale.z);
                // Set the particle effect position
                m_Particles.localPosition = new Vector3(m_Particles.localPosition.x, -m_MaxRange, m_Particles.localPosition.z);
            }
            else
            {
                // Define the ray length
                m_Ray.localScale = new Vector3(m_Ray.localScale.x, hitInfo.distance, m_Ray.localScale.z);
                // Set the particle effect position
                m_Particles.localPosition = new Vector3(m_Particles.localPosition.x, -hitInfo.distance, m_Particles.localPosition.z);
            }

            //Debug.Log("Test : " + hitInfo.transform.name);
            if ((!m_UseMaxRange || hitInfo.distance <= m_MaxRange) && hitInfo.transform.gameObject.layer == LayersUtils.HeroLayerMask)
            {
                // Stop its routine
                m_Routine.StopRoutine();
                // Inform the GameManager
                GameManager.Instance.Lost(-m_Dammage);
            }
        }
    }

    public override void ReInit()
    {
        base.ReInit();
    }

    public override void Spawn(Vector3 position)
    {
    }
}