﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class EnemyRoutine : MonoBehaviour
{
    public bool UseMotor;
    public bool Loop = true;

    // Loop finished ? (used for unloop routine)
    private bool m_TranslationLoopFinished;
    private bool m_RotationLoopFinished;

    // Enable
    private bool m_Enable;

    // Enemy transform
    private Character m_Character;
    private Transform m_Transform;

    // Translation
    public bool m_Translate;
    public bool Translate
    {
        get { return m_Translate; }
        set { m_Translate = value; }
    }
    public List<Vector3> Translations;
    public List<float> TranslationSpeeds;
    public List<bool> TranslationPauses;
    public List<bool> TranslationsHermite;
    private Vector3[] m_Translations;
    private float[] m_TranslationSpeeds;
    private Vector3 m_BeginPos;
    private Vector3 m_EndPos;
    private int m_CurrentTranslation;
    private Timer m_TranslationTimer;
    // Rotation
    public bool m_Rotate;
    public bool Rotate
    {
        get { return m_Rotate; }
        set { m_Rotate = value; }
    }
    public List<Vector3> Rotations;
    public List<float> RotationSpeeds;
    public List<bool> RotationPauses;
    public List<bool> RotationsHermite;
    private Quaternion[] m_Rotations;
    private float[] m_RotationSpeeds;
    private Quaternion m_BeginRot;
    private Quaternion m_EndRot;
    private int m_CurrentRotation;
    private Timer m_RotationTimer;
    private bool m_WithoutHermite;

	void Awake()
    {
        m_Enable = true;
        m_WithoutHermite = false;

        m_TranslationLoopFinished = false;
        m_RotationLoopFinished = false;

        m_Transform = transform;

        if (UseMotor)
        {
            m_Character = GetComponent<Character>();
            m_Enable = false;
        }
        // Translations
        if (m_Translate)
        {
            if (Translations != null && Translations.Count > 0)
            {
                m_Translations = Translations.ToArray();
                m_TranslationSpeeds = TranslationSpeeds.ToArray();
                m_TranslationTimer = new Timer();
                if (!UseMotor)
                {
                    m_CurrentTranslation = 0;
                    SetTranslation();
                }
            }
            else m_Translate = false;
        }

        // Rotation
        if (m_Rotate)
        {
            if (Rotations != null && Rotations.Count > 0)
            {
                m_Rotations = new Quaternion[Rotations.Count];
                for (int i = 0; i < Rotations.Count; ++i)
                {
                    m_Rotations[i] = Quaternion.Euler(Rotations[i]);
                }
                m_RotationSpeeds = RotationSpeeds.ToArray();
                m_RotationTimer = new Timer();
                if (!UseMotor)
                {
                    m_CurrentRotation = 0;
                    SetRotation();
                }
            }
            else m_Rotate = false;
        }
	}

    public void UpdateRoutine()
    {
        if (!m_Enable)
            return;

        // Movements
        // => Translation
        if (m_Translate && !m_TranslationLoopFinished)
        {
            if (!m_TranslationTimer.UpdateTime())
            {
                if (!UseMotor && !TranslationPauses[m_CurrentTranslation])
                {
                    if (TranslationsHermite[m_CurrentTranslation]) m_Transform.position = Vector3.Lerp(m_BeginPos, m_EndPos, m_TranslationTimer.GetHermiteProgress());
                    else m_Transform.position = Vector3.Lerp(m_BeginPos, m_EndPos, m_TranslationTimer.Progress());
                }
            }
            else
            {
                if (Loop)
                {
                    m_CurrentTranslation = (m_CurrentTranslation + 1) % m_Translations.Length;
                    SetTranslation();
                }
                else
                {
                    m_CurrentTranslation++;
                    if (m_CurrentTranslation == m_Translations.Length) m_TranslationLoopFinished = true;
                    else SetTranslation();
                }
            }
        }

        // => Rotation
        if (m_Rotate && !m_RotationLoopFinished)
        {
            if (!m_RotationTimer.UpdateTime())
            {
                if (!UseMotor && !RotationPauses[m_CurrentRotation])
                {
                    if (RotationsHermite[m_CurrentRotation]) m_Transform.rotation = Quaternion.Lerp(m_BeginRot, m_EndRot, m_RotationTimer.GetHermiteProgress());
                    else m_Transform.rotation = Quaternion.Lerp(m_BeginRot, m_EndRot, m_RotationTimer.Progress());
                }
            }
            else
            {
                if (Loop)
                {
                    m_CurrentRotation = (m_CurrentRotation + 1) % m_Rotations.Length;
                    SetRotation();
                }
                else
                {
                    m_CurrentRotation++;
                    if (m_CurrentRotation == m_Rotations.Length) m_RotationLoopFinished = true;
                    else SetRotation();
                }
            }
        }
    }

    private void SetTranslation()
    {
        if (!TranslationPauses[m_CurrentTranslation])
        {
            if (UseMotor)
            {
                m_Character.MustGoSomewhere(m_Transform.position + m_Translations[m_CurrentTranslation], m_TranslationSpeeds[m_CurrentTranslation]);
            }
            else
            {
                m_BeginPos = m_Transform.position;
                m_EndPos = m_BeginPos + m_Translations[m_CurrentTranslation];
            }
        }
        
        m_TranslationTimer.Restart(m_TranslationSpeeds[m_CurrentTranslation]);
    }

    private void SetRotation()
    {
        if (!RotationPauses[m_CurrentRotation])
        {
            if (UseMotor)
            {
                // TODO
            }
            else
            {
                m_BeginRot = m_Transform.rotation;
                m_EndRot = m_Transform.rotation * m_Rotations[m_CurrentRotation];
            }
        }

        m_RotationTimer.Restart(m_RotationSpeeds[m_CurrentRotation]);
    }

    public void StopRoutine()
    {
        m_Enable = false;
    }

    public void ContinueRoutine()
    {
        m_Enable = true;
    }

    public void StartRoutine()
    {
        m_TranslationLoopFinished = false;
        m_RotationLoopFinished = false;
        if (m_Translate)
        {
            if (Translations != null && Translations.Count > 0)
            {
                m_CurrentTranslation = 0;
                SetTranslation();
            }
        }
        if (m_Rotate)
        {
            if (Rotations != null && Rotations.Count > 0)
            {
                m_CurrentRotation = 0;
                SetRotation();
            }
        }
        m_Enable = true;
    }
}