﻿using UnityEngine;
using System.Collections;

public class Bot : Enemy
{
    // Body
    private InteractTrigger m_Trigger;

    // View
    public Transform m_View;
    private Ray m_Ray;

    protected override void Start()
    {
        // Create the character motor
        m_CharacterAnimator = gameObject.AddComponent<Hero_Animator>();
        Hero_Physic heroPhysic = new Hero_Physic(m_CharacterModel, GetComponentInChildren<CharacterController>());
        m_CharacterMotor = gameObject.AddComponent<Character_Motor>();
        m_CharacterMotor.Initialize(m_CharacterModel, m_CharacterAnimator, heroPhysic);

        m_Trigger = GetComponentInChildren<InteractTrigger>();
        m_Ray = new Ray();

        base.Start();
    }

    public override void UpdateCharacter()
    {
        base.UpdateCharacter();

        // Motor update
        m_CharacterMotor.UpdateMotor();

        // The player touches it ?
        if (m_Trigger.IsIn)
        {
            GameManager.Instance.Lost(-m_Dammage);
        }

        m_Ray.origin = m_View.position;
        m_Ray.direction = m_View.up;

        RaycastHit hitInfo;

        if (Physics.Raycast(m_Ray, out hitInfo, Mathf.Infinity, LayersUtils.HeroLayerWithOcclusion))
        {
            //Debug.Log("Test : " + hitInfo.transform.name);
            if (hitInfo.transform.gameObject.layer == LayersUtils.HeroLayerMask)
            {
                // Stop its routine
                m_Routine.StopRoutine();
                // Inform the GameManager
                GameManager.Instance.Lost(-m_Dammage);
            }
        }
    }

    public override void ReInit()
    {
        base.ReInit();
    }
}