using UnityEngine;
using System.Collections;

public class Character_Physic
{
	protected Transform m_CharacterModel;
	protected float m_VacuumDistance;
	protected float m_PlatformDistance;
	protected float m_WallOnHeadDistance;
	
	public Character_Physic(Transform characterModel)
	{
		m_CharacterModel = characterModel;
		m_VacuumDistance = 10f;
		m_PlatformDistance = 1f;
		m_WallOnHeadDistance = 0.75f;
	}
	
    // Test if the character has a wall just on his head : usefull when he's jumping
	public bool WallOnHead()
	{
		Ray ray = new Ray(m_CharacterModel.position,m_CharacterModel.up);
		return Physics.Raycast(ray,m_WallOnHeadDistance,LayersUtils.GroundLayer);
	}
}