using UnityEngine;
using System.Collections;

public class Character : MonoBehaviour
{
	protected CharacterSettings.Type m_Type;
	public CharacterSettings.Type Type
	{
		get { return m_Type; }
	}
	public bool IsHero
	{
		get { return (m_Type == CharacterSettings.Type.Hero); }
	}
	
	// Manager and character transforms
	protected Transform m_Transform;
	public Transform m_CharacterModel;
	
	// Character motor
	protected Character_Motor m_CharacterMotor;
	
	// Character animator
	protected Character_Animator m_CharacterAnimator;
	public Character_Animator CharacterAnimator
	{
		get { return m_CharacterAnimator; }
	}
	
	// Character physic
	protected Character_Physic m_CharacterPhysic;
	
	// Spawn offset
	protected Vector3 m_SpawnOffset;

	protected virtual void Start()
	{
		m_Transform = transform;
	}
	
	// Update is called once per frame
	public virtual void UpdateCharacter()
	{
	}

    #region Events
    // Called when the player die
    public virtual void ReInit()
    {
    }

    // Called when a checkpoint is activated to save the status
    public virtual void SaveStatus()
    {
    }

    public virtual void Spawn(Vector3 position)
	{
        if (m_CharacterMotor != null)
        {
            m_CharacterMotor.ReInit();
        }
		m_Transform.position = position + m_SpawnOffset;
		m_CharacterModel.localPosition = Vector3.zero;
		m_CharacterModel.localRotation = Quaternion.identity;
    }

    // The character can move ?
    public virtual void CharacterCanMove(bool can)
    {
    }

    // The character is on a platforme ? (and he must follow its move)
    public virtual void CharacterOnPlatform(bool isOn, bool canMove, Elevator platform)
    {
        m_CharacterMotor.IsOnPlatform(isOn, canMove, platform);
    }

    // The character can interact with something (InteractiveElement)
    public virtual void CharacterCanUseSomething(bool can, InteractiveElement element)
    {
    }

    // The character must go in a defined position
    public virtual void MustGoSomewhere(Vector3 position, float duration)
    {
        m_CharacterMotor.MustGoSomewhere(position, duration);
    }

    // Teleport the character in the defined position
    public virtual void Teleport(Vector3 position)
    {
        m_CharacterModel.position = position;
    }
    #endregion
}