using UnityEngine;
using System.Collections;

// a faire : bool selection : si selection
// chercher groupes
// verifier que c'est valide
// Application.LoadLevel(level);

public class Jeu : MonoBehaviour {
	
	// Representation de la grille au niveau des donnees
	private GameObject[,] grille;
	
	// Constantes pour le remplissage
	private const float grilleX = 0.0f;
	private const float grilleY = 0.0f;
	private const float intervalle = 0.5f;
	private const int nbColonnes = 8;
	private const int nbLignes = 8;

	// Liste des cases possibles
	public GameObject caseAgilite;
	public GameObject caseAir;
	public GameObject caseEau;
	public GameObject caseFeu;
	public GameObject caseForce;
	public GameObject caseTerre;
	
	// Texture des cases
	public Texture2D textureAgilite;
	public Texture2D textureAir;
	public Texture2D textureEau;
	public Texture2D textureFeu;
	public Texture2D textureForce;
	public Texture2D textureTerre;
	
	// Position dans le tableau de la case selectionnee
	// S'il n'y a pas de case selectionnee, les variables sont egales a -1
	private int selectionneeI;
	private int selectionneeJ;
	
	// Liste des groupes
	private ArrayList listeGroupes;
	
	// Machine a etats : etat courant
	string etat = "";
	
	// Enregistrer un temps de depart pour chaque attente
	float tempsDepart;
	
	// GUI
	//public Texture2D joueur;
	public Texture2D ennemiFeu;
	public Texture2D barreVieTexture;
	public Font font;
	private bool afficherRegles;
	private string info;
	
	// Joueur actif
	private bool estLeJoueur;
	private IA ia;
	
	// Compteur de combo
	private int combo;
	
	// Inventaire du joueur
	private int joueurNombreFeu;
	private int joueurNombreEau;
	private int joueurNombreTerre;
	private int joueurNombreAir;
	private int joueurNombreForce;
	private int joueurNombreAgilite;
	
	// Inventaire de l'ennemi
	private int ennemiNombreFeu;
	private int ennemiNombreEau;
	private int ennemiNombreTerre;
	private int ennemiNombreAir;
	private int ennemiNombreForce;
	private int ennemiNombreAgilite;
	
	// Points de vie
	private int pvJoueur;
	private int pvMaxJoueur;
	private float pvEnnemi; // float : pour les calculs d'affichage de la barre de vie
	private float pvMaxEnnemi;
	
	// Fin du jeu
	public string niveauGagne = "";
	public string niveauPerdu = "";

	// Use this for initialization
	void Start()
	{
		selectionneeI = selectionneeJ = -1;
		
		grille = new GameObject[nbLignes,nbColonnes];
		
		for(int i=0 ; i<nbLignes ; i++)
		{
			for(int j=0 ; j<nbColonnes ; j++)
			{
				GameObject cloneTile = CreerNouvelleCase(i, j);
				grille[i,j] = cloneTile;
			}
		}
		
		//AfficherGrille();
		
		estLeJoueur = false;
		ia = new IA();
		
		joueurNombreFeu = joueurNombreEau = joueurNombreTerre = joueurNombreAir = joueurNombreForce = joueurNombreAgilite = 0;
		ennemiNombreFeu = ennemiNombreEau = ennemiNombreTerre = ennemiNombreAir = ennemiNombreForce = ennemiNombreAgilite = 0;
		
		pvMaxJoueur = pvJoueur = 200;
		pvMaxEnnemi = pvEnnemi = 200;
		
		combo = -99;
		
		afficherRegles = true;
		info = "";
		
		etat = "chercher";
	}
	
	// Update is called once per frame
	void Update()
	{
		if (pvEnnemi == 0)
		{
			// C'est gagne !
			Application.LoadLevel(niveauGagne);
		}
		
		if (pvJoueur == 0)
		{
			// C'est perdu...
			Application.LoadLevel(niveauPerdu);
		}
		
		// L'init se fait deja dans le start
		switch(etat)
		{
			case "chercher":
				ChercherGroupes();
				break;
			case "jouer":
				if (estLeJoueur)
				{
					info = "A vous de jouer";
				}
				else
				{
					info = "L'ennemi joue";
					JeuIA();
				}
				break;
			case "detruire":
				DetruireGroupes();
				break;
			case "remplacer":
				RemplacerGroupes();
				break;
		}
	}
	
	GameObject CreerNouvelleCase(int i, int j)
	{
		float x = grilleX - 1.75f + j * intervalle;
		float y = grilleY + 1.75f - i * intervalle;
		GameObject cloneTile = null;
		
		int tmp = Random.Range(1, 7);
		GameObject typeCase = null;
		switch(tmp)
		{
		case 1:
			typeCase = caseAgilite;
			//Debug.Log(i + " " + j + " : Agilite (vert)");
			break;
		case 2:
			typeCase = caseAir;
			//Debug.Log(i + " " + j + " : Air (blanc)");
			break;
		case 3:
			typeCase = caseEau;
			//Debug.Log(i + " " + j + " : Eau (bleu)");
			break;
		case 4:
			typeCase = caseFeu;
			//Debug.Log(i + " " + j + " : Feu (rouge)");
			break;
		case 5:
			typeCase = caseForce;
			//Debug.Log(i + " " + j + " : Force (jaune)");
			break;
		case 6:
			typeCase = caseTerre;
			//Debug.Log(i + " " + j + " : Terre (orange)");
			break;
		}
		
		cloneTile = (GameObject)Object.Instantiate(typeCase, new Vector3(x, 2.25f, -4.2f), Quaternion.identity);

		cloneTile.transform.Rotate(Vector3.right, 270.0f);
		getCase(cloneTile).Move(0.0f, y - 2.25f, 0.0f, 1.0f);
		
		return cloneTile;
	}
	
	void AfficherGrille()
	{
		for(int i=0 ; i<nbColonnes ; i++)
		{
			for(int j=0 ; j<nbLignes ; j++)
			{
				Debug.Log("Case en " + i + " / " + j + " : " + getCase(grille[i,j]).typeCase);
			}
		}
	}
	
	// Fonction pour avoir acces plus facilement aux fonctions du script d'une case
	CaseBehaviour getCase(GameObject caseObject)
	{
		return (CaseBehaviour) caseObject.GetComponent(typeof(CaseBehaviour));
	}
	
	// Message envoye depuis une case selectionnee
	void SelectionCase(Vector3 position)
	{
		int j = (int) ((position.x - grilleX + 1.75f) / intervalle);
		int i = (int) ((grilleY + 1.75f - position.y) / intervalle);
		
		if (etat == "jouer")
		{
			//Debug.Log("Case selectionnee en " + i + " / " + j);
			
			// Si aucune case n'a ete selectionne avant
			if (selectionneeI == -1 && selectionneeJ == -1)
			{
				selectionneeI = i;
				selectionneeJ = j;
			}
			// Si il y a deja une case selectionnee
			else
			{
				// Alors on verifie d'abord que les deux cases sont adjacentes
				if ((Mathf.Abs(selectionneeI - i) + Mathf.Abs(selectionneeJ - j)) == 1)
				{
					// On peut les intervertir
					//Debug.Log("Elles sont adjacentes");
					
					// On les intervertit dans le tableau
					GameObject tmp = grille[i,j];
					grille[i,j] = grille[selectionneeI,selectionneeJ];
					grille[selectionneeI,selectionneeJ] = tmp;
					
					CaseBehaviour case1 = getCase(grille[selectionneeI,selectionneeJ]);
					CaseBehaviour case2 = getCase(grille[i,j]);
					
					// On verifie que ca fait bien nouveau groupe
					ChercherGroupes();
					
					if (listeGroupes.Count > 0)
					{
						// Alors le coup est valide
						// On les intervertit graphiquement
						case1.Move((selectionneeJ - j) * intervalle, (i - selectionneeI) * intervalle, -intervalle, 1.0f);
						case2.Move((j - selectionneeJ) * intervalle, (selectionneeI - i) * intervalle, intervalle, 1.0f);
						combo++;
						etat = "chercher";
					}
					else
					{
						// On restaure le tableau
						grille[selectionneeI,selectionneeJ] = grille[i,j];
						grille[i,j] = tmp;	
					}
					
					case1.Deselectionner();
					case2.Deselectionner();
					
					// Plus aucune case n'est selectionnee
					selectionneeI = -1;
					selectionneeJ = -1;
				}
				else
				{
					//Debug.Log("Elles ne sont pas adjacentes");
					
					CaseBehaviour case1 = getCase(grille[selectionneeI,selectionneeJ]);
					case1.Deselectionner();
					CaseBehaviour case2 = getCase(grille[i,j]);
					case2.Selectionner();
					
					// La nouvelle case selectionnee est la derniere cliquee
					selectionneeI = i;
					selectionneeJ = j;
				}
			}
		}
		else
		{
			CaseBehaviour case1 = getCase(grille[i,j]);
			case1.Deselectionner();
		}
	}
					
	void JeuIA()
	{
		// Attaquer si possible
		if ((ennemiNombreForce >= 5) && (ennemiNombreAgilite >= 5))
		{
			ennemiNombreForce -= 5;
			ennemiNombreAgilite -= 5;
			
			if (pvJoueur <= 10)
			{
				pvJoueur = 0;
			}
			else
			{
				pvJoueur -= 10;
			}
		}
		
		int[] coords = ia.Jouer(grille);
		
		if (coords != null)
		{
			int i1 = coords[0];
			int j1 = coords[1];
			int i2 = coords[2];
			int j2 = coords[3];
			
			// On les intervertit dans le tableau
			GameObject tmp = grille[i1,j1];
			grille[i1,j1] = grille[i2,j2];
			grille[i2,j2] = tmp;
					
			CaseBehaviour case1 = getCase(grille[i1,j1]);
			CaseBehaviour case2 = getCase(grille[i2,j2]);
			
			// On les intervertit graphiquement
			case1.Move((j1 - j2) * intervalle, (i2 - i1) * intervalle, intervalle, 1.0f);
			case2.Move((j2 - j1) * intervalle, (i1 - i2) * intervalle, -intervalle, 1.0f);
			
			combo++;
			
			etat = "chercher";
		}
		else
		{
			// Il n'y a plus de deplacement possible
			pvJoueur = 0;
		}
	}
	
	// Chercher tous les groupes de cases
	// Garder la liste de toutes ces cases en memoire
	// Groupe = au moins 3 cases adjacentes sur une meme ligne ou une meme colonne
	void ChercherGroupes()
	{
		int compteur = 1;
		string typeCourant = "";
		listeGroupes = new ArrayList(); // liste de tableau de 2 entiers
		
		// Recherche par ligne
		for(int i=0 ; i<nbLignes; i++)
		{
			for(int j=0 ; j<nbColonnes ; j++)
			{
				string nouveauType = getCase(grille[i,j]).typeCase;

				if(nouveauType.Equals(typeCourant))
				{
					compteur++;
				}
				else
				{
					typeCourant = nouveauType;
					if(compteur >= 3)
					{
						for(int k=0 ; k<compteur ; k++)
						{
							int[] coord = new int[2];
							coord[0] = i;
							coord[1] = j-1-k;
							
							listeGroupes.Add(coord);
							/*Debug.Log("Recherche par ligne. Type = " + typeCourant);
							Debug.Log("Ajout de coord depuis la recherche par ligne 1");*/
						}
					}
					compteur = 1;
				}
				
				if ((j == nbColonnes-1) && (compteur >= 3))
				{
					for(int k=0 ; k<compteur ; k++)
					{
						int[] coord = new int[2];
						coord[0] = i;
						coord[1] = j-k;
						
						listeGroupes.Add(coord);
						//Debug.Log("Ajout de coord depuis la recherche par ligne 2");
					}
				}
			}
			compteur = 1;
			typeCourant = "";
		}
		
		// Recherche par colonne
		for(int j=0 ; j<nbColonnes; j++)
		{
			for(int i=0 ; i<nbLignes ; i++)
			{
				string nouveauType = getCase(grille[i,j]).typeCase;
				if(nouveauType.Equals(typeCourant))
				{
					compteur++;
				}
				else
				{
					typeCourant = nouveauType;
					if(compteur >= 3)
					{
						for(int k=0 ; k<compteur ; k++)
						{
							int[] coord = new int[2];
							coord[0] = i-1-k;
							coord[1] = j;
							
							listeGroupes.Add(coord);
							//Debug.Log("Ajout de coord depuis la recherche par colonne 1");
						}
					}
					compteur = 1;
				}
				
				if ((i == nbLignes-1) && (compteur >= 3))
				{
					for(int k=0 ; k<compteur ; k++)
					{
						int[] coord = new int[2];
						coord[0] = i-k;
						coord[1] = j;
						
						listeGroupes.Add(coord);
						//Debug.Log("Ajout de coord depuis la recherche par colonne 2");
					}
				}
			}
			compteur = 1;
			typeCourant = "";
		}
		
		//AfficherListe(listeGroupes);
		
		int nbGroupes = (listeGroupes.Count - (listeGroupes.Count % 3)) / 3;
		//Debug.Log("Nombre de groupes : " + nbGroupes);
		
		if (nbGroupes > 0)
		{
			tempsDepart = Time.time;
			etat = "detruire";
		}
		else
		{
			etat = "jouer";
			combo = 0;
			estLeJoueur = !estLeJoueur;
		}
	}
	
	// Pour le debug : afficher le contenu de la liste de groupe
	void AfficherListe(ArrayList a)
	{
		Debug.Log("Groupes :");
		foreach(int[] coord in a)
		{
			Debug.Log("" + coord[0] + " " + coord[1]);
		}
	}
	
	// Verifie si la case courante n'a pas de doublon avant elle
	bool DejaDetruite(int indexListe, int i, int j)
	{
		for(int k=0 ; k<indexListe ; k++)
		{
			int[] coords = (int[]) listeGroupes[k];
			if ((coords[0] == i) && (coords[1] == j))
			{
				return true;
			}
		}
		return false;
	}
	
	// Detruire tous les groupes dans la grille
	void DetruireGroupes()
	{
		// Temps entre le deplacement des cases et la destruction des cases
		if ((Time.time - tempsDepart) <= 1.0f)
		{
			etat = "detruire";
		}
		else
		{
			for(int k=0 ; k<listeGroupes.Count ; k++)
			{
				int[] coords = (int[]) listeGroupes[k];
				GameObject case1 = grille[coords[0],coords[1]];
				case1.transform.localScale = Vector3.Lerp(case1.transform.localScale, new Vector3(0.0f, 0.0f, 0.0f), Time.deltaTime*2);
			}
			
			if (!((Time.time - tempsDepart) <= 2.0f))
			{
				for(int k=0 ; k<listeGroupes.Count ; k++)
				{
					int[] coords = (int[]) listeGroupes[k];
					
					// Verifier que la case n'a pas deja ete detruite
					if (!DejaDetruite(k, coords[0], coords[1]))
					{
						GameObject case1 = grille[coords[0],coords[1]];
						AjouterElement(estLeJoueur, getCase(case1).typeCase, combo);
						Destroy(case1);
					}
				}
				
				etat = "remplacer";
				tempsDepart = Time.time;
			}
		}
	}
	
	void AjouterElement(bool joueur, string type, int combo)
	{	
		if(combo>=0)
		{
			if (joueur)
			{
				switch(type)
				{
				case "Feu" :
					joueurNombreFeu += combo;
					break;
				case "Eau" :
					joueurNombreEau += combo;
					break;
				case "Terre" :
					joueurNombreTerre += combo;
					break;
				case "Air" :
					joueurNombreAir += combo;
					break;
				case "Force" :
					joueurNombreForce += combo;
					break;
				case "Agilite" :
					joueurNombreAgilite += combo;
					break;
				}
			}
			else
			{
				switch(type)
				{
				case "Feu" :
					ennemiNombreFeu += combo;
					break;
				case "Eau" :
					ennemiNombreEau += combo;
					break;
				case "Terre" :
					ennemiNombreTerre += combo;
					break;
				case "Air" :
					ennemiNombreAir += combo;
					break;
				case "Force" :
					ennemiNombreForce += combo;
					break;
				case "Agilite" :
					ennemiNombreAgilite += combo;
					break;
				}
			}
		}
	}
	
	// Remplacer les groupes detruits par de nouvelles cases
	void RemplacerGroupes()
	{
		//Debug.Log("REMPLACERGROUPE");
		for(int j=0 ; j<nbColonnes ; j++)
		{
			// On parcourt la colonne de bas en haut
			for(int i=(nbLignes-1) ; i>=0 ; i--)
			{
				//Debug.Log("I = " + i + " / J = " + j);
				// Si la case courante a ete detruite
				if (grille[i,j] == null)
				{
					int k = i - 1;
					
					// Quand la boucle est terminee, on a trouve quelle case doit remplacer la case courante
					while ((k >= 0) && (grille[k,j] == null))
					{
						k--;
					}
					
					// S'il y a une case vide tout en haut de la colonne
					if (k == -1)
					{
						// Alors on cree une nouvelle case au hasard
						GameObject nouvelleCase = CreerNouvelleCase(i,j);
						grille[i,j] = nouvelleCase;
					}
					else
					{
						// Sinon on descend la case non null la plus haute

						// Conversion Donnees / Vue
						//float x = grilleX - 1.75f + j * intervalle;
						float y = grilleY + 1.75f - i * intervalle;
						
						// Vue
						getCase(grille[k,j]).Move(0.0f, y - grille[k,j].transform.position.y, 0.0f, 1.0f);
						//grille[k,j].transform.position = new Vector3(x, y, -4.2f);
						// Donnees
						grille[i,j] = grille[k,j];
						
						grille[k,j] = null;
					}
				}
			}
		}
		
		if (!((Time.time - tempsDepart) <= 1.0f))
		{
			etat = "chercher";
			combo++;
		}
	}
	
	void OnGUI()
	{	
		GUI.skin.button.font = font;
		GUI.skin.button.normal.textColor = Color.black;
		GUI.skin.button.fontSize = (int)(Screen.height * 0.03f);
		GUI.skin.button.fontStyle = FontStyle.Bold;
		GUI.skin.button.alignment = TextAnchor.MiddleCenter;
		
		GUI.skin.label.font = font;
		GUI.skin.label.normal.textColor = Color.black;
		GUI.skin.label.fontSize = (int)(Screen.height * 0.03f);
		GUI.skin.label.fontStyle = FontStyle.Bold;
		GUI.skin.label.alignment = TextAnchor.MiddleCenter;
		
		GUI.Label(new Rect(Screen.width/2 - 105, 40, 210, 50), info);
		
		if (GUI.Button(new Rect(Screen.width/2 - 105, Screen.height - 50, 210, 50), "R\u00E8gles du jeu"))
		{
			afficherRegles = true;
		}
		
		GUIJoueur();
		GUIEnnemi();
		GUIRegles();
	}
	
	void GUIJoueur()
	{
		// Moitie de l'ecran en hauteur
		float halfScreen = Screen.height/2.0f;
		float visibleWidth = halfScreen*0.7f;
		
		//GUI.DrawTexture(new Rect(Screen.width - visibleWidth, 0, halfScreen, halfScreen), joueur);
		
		float hauteurLigne = (Screen.height-halfScreen)/5;
		
		// Bouton "Attaquer"
		// Coute 5 force + 5 agilite
		float largeurInventaire4 = visibleWidth / 4;
		GUI.DrawTexture(new Rect(0.0f, halfScreen, largeurInventaire4, hauteurLigne), textureForce);
		GUI.DrawTexture(new Rect(visibleWidth - largeurInventaire4, halfScreen, largeurInventaire4, hauteurLigne), textureAgilite);
		if (GUI.Button(new Rect(0.0f, halfScreen, visibleWidth, hauteurLigne), "5       Attaquer       5"))
		{
			if ((joueurNombreForce >= 5) && (joueurNombreAgilite >= 5) && estLeJoueur)
			{				
				joueurNombreForce -= 5;
				joueurNombreAgilite -= 5;
				
				if (pvEnnemi <= 10)
				{
					pvEnnemi = 0;
				}
				else
				{
					pvEnnemi -= 10;
				}
			}
		}
		
		// Affichage "Inventaire 4 elements"
		GUI.DrawTexture(new Rect(0.0f, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureFeu);
		GUI.Label(new Rect(0.0f, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), joueurNombreFeu.ToString());
		GUI.DrawTexture(new Rect(largeurInventaire4, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureEau);
		GUI.Label(new Rect(largeurInventaire4, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), joueurNombreEau.ToString());
		GUI.DrawTexture(new Rect(largeurInventaire4*2, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureTerre);
		GUI.Label(new Rect(largeurInventaire4*2, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), joueurNombreTerre.ToString());
		GUI.DrawTexture(new Rect(largeurInventaire4*3, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureAir);
		GUI.Label(new Rect(largeurInventaire4*3, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), joueurNombreAir.ToString());
		
		// Affichage "Inventaire Force + Agilite"
		float largeurInventaire2 = visibleWidth / 2;
		GUI.DrawTexture(new Rect(hauteurLigne/2, halfScreen + hauteurLigne*2, largeurInventaire4, hauteurLigne), textureForce);
		GUI.Label(new Rect(0.0f, halfScreen + hauteurLigne*2, largeurInventaire2, hauteurLigne), joueurNombreForce.ToString());
		GUI.DrawTexture(new Rect(largeurInventaire2 + hauteurLigne/2, halfScreen + hauteurLigne*2, largeurInventaire4, hauteurLigne), textureAgilite);
		GUI.Label(new Rect(largeurInventaire2, halfScreen + hauteurLigne*2, largeurInventaire2, hauteurLigne), joueurNombreAgilite.ToString());
		
		// Bouton "Competences 1 et 2"
		GUI.DrawTexture(new Rect(0.0f, halfScreen + hauteurLigne*3, largeurInventaire2/2, hauteurLigne), textureFeu);
		GUI.DrawTexture(new Rect(largeurInventaire2/2, halfScreen + hauteurLigne*3, largeurInventaire2/2, hauteurLigne), textureForce);
		if (GUI.Button(new Rect(0.0f, halfScreen + hauteurLigne*3, largeurInventaire2, hauteurLigne), "10     10"))
		{
			if ((joueurNombreFeu >= 10) && (joueurNombreForce >= 10) && estLeJoueur)
			{
				joueurNombreFeu -= 10;
				joueurNombreForce -= 10;
				
				if (pvEnnemi <= 30)
				{
					pvEnnemi = 0;
				}
				else
				{
					pvEnnemi -= 30;
				}
			}
		}
		GUI.DrawTexture(new Rect(largeurInventaire2, halfScreen + hauteurLigne*3, largeurInventaire2/2, hauteurLigne), textureEau);
		GUI.DrawTexture(new Rect(largeurInventaire2 + largeurInventaire2/2, halfScreen + hauteurLigne*3, largeurInventaire2/2, hauteurLigne), textureAgilite);
		if (GUI.Button(new Rect(largeurInventaire2, halfScreen + hauteurLigne*3, largeurInventaire2, hauteurLigne), "10     10"))
		{
			if ((joueurNombreEau >= 10) && (joueurNombreAgilite >= 10) && estLeJoueur)
			{
				joueurNombreEau -= 10;
				joueurNombreAgilite -= 10;
				
				if (pvJoueur >= 180)
				{
					pvJoueur = 200;
				}
				else
				{
					pvJoueur += 20;
				}
			}
		}
		
		// Bouton "Competences 3 et 4"
		/*GUI.Button(new Rect(0.0f, halfScreen + hauteurLigne*4, largeurInventaire2, hauteurLigne), "Competence 3");
		GUI.Button(new Rect(largeurInventaire2, halfScreen + hauteurLigne*4, largeurInventaire2, hauteurLigne), "Competence 4");*/
		
		// Barre de vie
		float longueurBarreVieMax = (Screen.width - Screen.height*0.9f - 40);
		GUI.DrawTexture(new Rect(Screen.width/2-10-longueurBarreVieMax,0,longueurBarreVieMax*pvJoueur/pvMaxJoueur,hauteurLigne/2), barreVieTexture);
		GUI.Label(new Rect(Screen.width/2-longueurBarreVieMax -100 + longueurBarreVieMax*pvJoueur/pvMaxJoueur, 0, 100, hauteurLigne/2), pvJoueur.ToString());
	}
	
	void GUIEnnemi()
	{
		// Moitie de l'ecran en hauteur
		float halfScreen = Screen.height/2.0f;
		float visibleWidth = halfScreen*0.7f;
		
		// On insere l'image avec comme hauteur et largeur la hauteur de l'ecran /2, et on le place de telle
		// facon qu'on ne voit que 80% de l'image
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth, 0, halfScreen, halfScreen), ennemiFeu);
		
		float hauteurLigne = (Screen.height-halfScreen)/5;
		
		// Bouton "Attaquer"
		/*if (GUI.Button(new Rect(Screen.width - visibleWidth, halfScreen, visibleWidth, hauteurLigne), "Attaquer"))
		{
			pvJoueur -= 10;
		}*/
		
		// Affichage "Inventaire 4 elements"
		float largeurInventaire4 = visibleWidth / 4;
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureFeu);
		GUI.Label(new Rect(Screen.width - visibleWidth, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), ennemiNombreFeu.ToString());
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth + largeurInventaire4, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureEau);
		GUI.Label(new Rect(Screen.width - visibleWidth + largeurInventaire4, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), ennemiNombreEau.ToString());
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth + largeurInventaire4*2, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureTerre);
		GUI.Label(new Rect(Screen.width - visibleWidth + largeurInventaire4*2, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), ennemiNombreTerre.ToString());
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth + largeurInventaire4*3, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), textureAir);
		GUI.Label(new Rect(Screen.width - visibleWidth + largeurInventaire4*3, halfScreen + hauteurLigne, largeurInventaire4, hauteurLigne), ennemiNombreAir.ToString());
		
		// Affichage "Inventaire Force + Agilite"
		float largeurInventaire2 = visibleWidth / 2;
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth + hauteurLigne/2, halfScreen + hauteurLigne*2, largeurInventaire4, hauteurLigne), textureForce);
		GUI.Label(new Rect(Screen.width - visibleWidth, halfScreen + hauteurLigne*2, largeurInventaire2, hauteurLigne), ennemiNombreForce.ToString());
		GUI.DrawTexture(new Rect(Screen.width - visibleWidth + largeurInventaire2 + hauteurLigne/2, halfScreen + hauteurLigne*2, largeurInventaire4, hauteurLigne), textureAgilite);
		GUI.Label(new Rect(Screen.width - visibleWidth + largeurInventaire2, halfScreen + hauteurLigne*2, largeurInventaire2, hauteurLigne), ennemiNombreAgilite.ToString());
		
		// Bouton "Competences 1 et 2"
		/*GUI.Button(new Rect(Screen.width - visibleWidth, halfScreen + hauteurLigne*3, largeurInventaire2, hauteurLigne), "Competence 1");
		GUI.Button(new Rect(Screen.width - visibleWidth + largeurInventaire2, halfScreen + hauteurLigne*3, largeurInventaire2, hauteurLigne), "Competence 2");
		
		// Bouton "Competences 3 et 4"
		GUI.Button(new Rect(Screen.width - visibleWidth, halfScreen + hauteurLigne*4, largeurInventaire2, hauteurLigne), "Competence 3");
		GUI.Button(new Rect(Screen.width - visibleWidth + largeurInventaire2, halfScreen + hauteurLigne*4, largeurInventaire2, hauteurLigne), "Competence 4");*/
		
		// Barre de vie
		float longueurBarreVieMax = (Screen.width - Screen.height*0.9f - 40);
		GUI.DrawTexture(new Rect(Screen.width/2+10+((pvMaxEnnemi-pvEnnemi)/pvMaxEnnemi)*longueurBarreVieMax,0,longueurBarreVieMax*pvEnnemi/pvMaxEnnemi,hauteurLigne/2), barreVieTexture);
		GUI.Label(new Rect(Screen.width/2+((pvMaxEnnemi-pvEnnemi)/pvMaxEnnemi)*longueurBarreVieMax, 0, 100, hauteurLigne/2), pvEnnemi.ToString());
	}
	
	void GUIRegles()
	{
		GUI.skin.button.font = font;
		GUI.skin.button.normal.textColor = Color.black;
		GUI.skin.button.fontSize = 20;
		GUI.skin.button.fontStyle = FontStyle.Bold;
		GUI.skin.button.alignment = TextAnchor.MiddleLeft;
		
		if (afficherRegles)
		{			
			string texte = "Le but est de combattre l'ennemi dans un jeu de type bejeweled. Le fait de combiner au\n" +
			 	"moins 3 cases identiques \u00E0 la suite (horizontalement ou verticalement) vous permet de\n" +
				"cumuler des \u00E9l\u00E9ments de chaque type dans votre inventaire, \u00E0 gauche de l'\u00E9cran. Les \u00E9l\u00E9ments\n" +
				"sont affich\u00E9s dans cette ordre dans l'inventaire : feu, eau, terre, air, force et agilit\u00E9.\n" +
				"Chaque d\u00E9placement est possible en alternant 2 cases (un clic sur la 1\u00E8re case puis un\n" +
				"clic sur la 2\u00E8me case).\n\n" +
				"Pour attaquer l'ennemi, il existe 2 possibilit\u00E9s en utilisant les \u00E9l\u00E9ments pr\u00E9sents dans\n" +
				"votre inventaire. Le bouton 'Attaquer' utilise 5 \u00E9l\u00E9ments de feu et 5 \u00E9l\u00E9ments d'agilit\u00E9.\n" +
				"Cette option attaque l'ennemi pour 10 points de vie. Les comp\u00E9tences sont plus efficaces.\n" +
				"Vous en avez 2 pendant ce jeu. La 1\u00E8re est 'Poing de feu' et co\u00FBte 10 feu et 10 force. Elle\n" +
				"attaque l'ennemi pour 30 points de vie. La 2\u00E8me comp\u00E9tence ('Brumisateur') vous permet\n" +
				"de regagner 20 points de vie en d\u00E9pensant 10 eau et 10 agilit\u00E9. L'ennemi a seulement\n" +
				"acc\u00E8s au bouton 'Attaquer'.\n\n" +
				"Vous avez chacun 200 points de vie au d\u00E9but de la partie. Celui qui arrive \u00E0 0 a perdu.\n\n" +
				"Bonne chance !";
			
			if (GUI.Button(new Rect(0, 0, Screen.width, Screen.height), texte))
			{
				afficherRegles = false;
			}
		}
	}
}
