using UnityEngine;
using System.Collections;

public class scoreHighscoreTemps : MonoBehaviour {
	
	private int score;
	private float temps;
	private int highScore;
	
	private int largeurEcran;
	private int hauteurEcran;
	private int textesLargeur;
	private int textesHauteur;
	
	// Use this for initialization
	void Start () {
		
		Load ();
	}
	
	void Load()
	{
		score = PlayerPrefs.GetInt("score");
		temps = PlayerPrefs.GetFloat("temps");
		highScore = PlayerPrefs.GetInt("highScore");
	}		
	
	// Update is called once per frame
	void Update () {
		largeurEcran = Screen.width;
		hauteurEcran = Screen.height;
		textesHauteur = hauteurEcran/7;
		textesLargeur = largeurEcran/7;
		
		if(score > highScore)
		{
			highScore = score;
			PlayerPrefs.SetInt("highScore",highScore);
		}
	}
	
	void OnGUI()
	{
		GUI.Label(new Rect((largeurEcran/2)+(textesLargeur*2)-(textesLargeur),(hauteurEcran/2),textesLargeur,textesHauteur),score.ToString());
		GUI.Label(new Rect((largeurEcran/2)+(textesLargeur*2)-(textesLargeur),(hauteurEcran/2)-(textesHauteur*2)+(textesHauteur/2),textesLargeur,textesHauteur),highScore.ToString());
		GUI.Label(new Rect((largeurEcran/2)+(textesLargeur*2)-(textesLargeur),(hauteurEcran/2)+(textesHauteur*2)-(textesHauteur/2),textesLargeur,textesHauteur),Mathf.Floor(temps).ToString()+" secondes!");
	}
}
