using UnityEngine;
using System.Collections;

public class Timer 
{
	private float m_Duration;
	public float Duration
	{
		get { return m_Duration; }
		set { if(value > 0f) m_Duration = value; }
	}
	private float m_Timer;
	public float ElapsedTime
	{
		get { return m_Timer; }
	}
	private bool m_IsLaunched;
	public bool IsLaunched
	{
		get { return m_IsLaunched; }
	}
	
	#region Contructors
	public Timer()
	{
		m_Duration = 0f;
		m_Timer = 0f;
		m_IsLaunched = false;
	}
	
	public Timer(float duration)
	{
		m_Duration = duration;
		m_Timer = 0f;
		m_IsLaunched = false;
	}
	#endregion
	
	#region Public functions
	public void Start()
	{
		m_IsLaunched = true;
	}
	
	public bool UpdateTime()
	{
		if(!m_IsLaunched)
			return false;
		
		m_Timer += Time.deltaTime;
		if(IsFinished())
		{
			m_IsLaunched = false;
			return true;
		}
		return false;
	}
	
	public void Restart()
	{
		Restart(m_Duration);
	}
	
	public void Restart(float duration)
	{
		m_Duration = duration;
		m_Timer = 0f;
		m_IsLaunched = true;
	}
	
	public bool IsFinished()
	{
		return m_Timer >= m_Duration;
	}
	
	public float Progress()
	{
		if(m_Duration == 0f)
		{
			return 0f;
		}
		
		if(m_Timer >= m_Duration)
		{
			return 1f;
		}
		
		return m_Timer / m_Duration;
	}

    public float GetHermiteProgress()
    {
        if (m_Duration == 0)
        {
            return 0f;
        }
        if (m_Timer >= m_Duration)
        {
            return 1f;
        }
        else
        {
            return CustomMath.Hermite(0f, 1f, (m_Timer / m_Duration));
        }
    }
	#endregion
}