﻿using UnityEngine;
using System.Collections;

public class TextBuilder : MonoBehaviour
{
    private string m_Txt;
    private GameObject[] m_Numbers;
    private float m_SizeSpace = 0.65f;
    private float m_Size = 0.3f;

    public void Start()
    {
    }

    public void SetText(string txt)
    {
        m_Txt = txt;
        m_Numbers = new GameObject[m_Txt.Length];
        for (int i = m_Txt.Length-1; i >= 0; --i)
        {
            GameObject go = Instantiate(Resources.Load("Numbers/" + m_Txt[i])) as GameObject;
            go.name = m_Txt[i].ToString();
            go.transform.parent = transform;
            go.transform.localPosition = Vector3.zero;
            go.transform.localPosition += new Vector3(-(m_Txt.Length-1-i) * m_SizeSpace, 0f);
            go.transform.localScale *= m_Size;
            m_Numbers[i] = go;
        }

        HideText();
    }

    public void DisplayText()
    {
        foreach (GameObject go in m_Numbers)
        {
            go.SetActive(true);
        }
    }

    public void HideText()
    {
        foreach (GameObject go in m_Numbers)
        {
            go.SetActive(false);
        }
    }
}