using UnityEngine;
using System.Collections;

public class Fade : MonoBehaviour
{
    private static Fade s_Instance;
    public static Fade Instance
    {
        get
        {
            if (s_Instance == null)
            {
                s_Instance = GameObject.FindObjectOfType(typeof(Fade)) as Fade;
            }
            return s_Instance;
        }
    }

    public Texture2D m_PatternTexture;
    public Color m_Color;
    public float m_FadeTime = 1f;
    public bool m_PlayOnStart;
    public bool m_Opaque;
    public bool Opaque
    {
        get { return m_Opaque; }
    }

	void Start()
    {
        if(m_Opaque)
        {
            m_Color.a = 1f;
            if(m_PlayOnStart) m_Opaque = false;
        }
        else
        {
            m_Color.a = 0f;
            if(m_PlayOnStart) m_Opaque = true;
        }
	}
	
	void Update()
    {
        if (m_Opaque && m_Color.a < 1f)
        {
            m_Color.a += Time.deltaTime / m_FadeTime;
        }
        else if (!m_Opaque && m_Color.a > 0f)
        {
            m_Color.a -= Time.deltaTime / m_FadeTime;
        }
	}

    void OnGUI()
    {
        if (m_Color.a <= 0) return;
        GUI.color = m_Color;
        GUI.depth = -9999;
        GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), this.m_PatternTexture, ScaleMode.StretchToFill);
    }

    public void Out()
    {
        Out(m_FadeTime);
    }
    public void Out(float time)
    {
        ChangeState(false, time);
    }

    public void In()
    {
        In(m_FadeTime);
    }
    public void In(float time)
    {
        ChangeState(true, time);
    }

    private void ChangeState(bool opaque, float time)
    {
        m_Opaque = opaque;
        m_FadeTime = time;
    }

    public void InstantOut()
    {
        m_Opaque = false;
        m_Color.a = 0f;
    }

    public void InstantIn()
    {
        m_Opaque = true;
        m_Color.a = 1f;
    }
}