﻿using UnityEngine;
using System.Collections;

public class GameEnd : StoryEvent
{
    protected Brick[] m_Bricks;
    private InteractTrigger m_BeginTrigger;
    public Renderer m_HeartRenderer;
    public Animator m_HeartAnimator;
    public InteractTrigger m_HeartTrigger;
    public Color m_FirstColor;
    public Color m_LastColor;
    public Transform m_FirstPosition;
    public Transform m_SecondPosition;
    public Renderer m_HeroRenderer;

    // Scores
    public GameObject m_ScoreScreen;
    public GUIText m_TotalScore;
    public GUIText m_TotalTime;
    public GUIText m_LVL0Name;
    public GUIText m_LVL0Score;
    public GUIText m_LVL0Time;
    public GUIText m_LVL1Name;
    public GUIText m_LVL1Score;
    public GUIText m_LVL1Time;
    public GUIText m_LVL2Name;
    public GUIText m_LVL2Score;
    public GUIText m_LVL2Time;
    public GUIText m_LVL3Name;
    public GUIText m_LVL3Score;
    public GUIText m_LVL3Time;
    public GUIText m_EnterForQuit;

    // Sounds
    public AudioClip m_EndSound;
    private AudioSource m_AudioSource;

    public override bool Initialize()
    {
        m_ScoreScreen.SetActive(false);
        m_AudioSource = GetComponent<AudioSource>();
        m_AudioSource.pitch = 1.87f;
        return base.Initialize();
    }

    public override void StartStory()
    {
        base.StartStory();
        m_Bricks = GameObject.Find("Level/Level creator").GetComponentsInChildren<Brick>();
        m_TotalScore.enabled = false;
        m_TotalTime.enabled = false;
        m_LVL0Name.enabled = false;
        m_LVL0Score.enabled = false;
        m_LVL0Time.enabled = false;
        m_LVL1Name.enabled = false;
        m_LVL1Score.enabled = false;
        m_LVL1Time.enabled = false;
        m_LVL2Name.enabled = false;
        m_LVL2Score.enabled = false;
        m_LVL2Time.enabled = false;
        m_LVL3Name.enabled = false;
        m_LVL3Score.enabled = false;
        m_LVL3Time.enabled = false;
        m_EnterForQuit.enabled = false;
        m_BeginTrigger = GetComponent<InteractTrigger>();
        StartCoroutine("C_End");
    }

    private IEnumerator C_End()
    {
        while (!m_BeginTrigger.IsIn)
        {
            yield return 0;
        }

        // First move
        GameManager.Instance.PlayerCanMove = false;
        m_BeginTrigger.InteractCharacter.MustGoSomewhere(m_FirstPosition.position, 3f);
        yield return new WaitForSeconds(4f);
        // Second move
        m_BeginTrigger.InteractCharacter.MustGoSomewhere(m_SecondPosition.position, 1f);

        // Wait for collision with the heart trigger
        while (!m_HeartTrigger.IsIn)
        {
            yield return 0;
        }
        m_HeroRenderer.enabled = false;
        yield return new WaitForSeconds(0.5f);

        // The heart begin to die => purple
        m_AudioSource.Stop();
        Timer timer = new Timer(1f);
        timer.Start();
        Material material = m_HeartRenderer.material;
        Color init = material.color;
        while (!timer.UpdateTime())
        {
            material.color = Color.Lerp(init, m_FirstColor, timer.GetHermiteProgress());
            yield return 0;
        }
        m_HeartAnimator.SetBool("Stop", true);
        yield return new WaitForSeconds(0.5f);

        // the heart is dying => black
        timer.Restart();
        while (!timer.UpdateTime())
        {
            material.color = Color.Lerp(m_FirstColor, m_LastColor, timer.GetHermiteProgress());
            yield return 0;
        }
        yield return new WaitForSeconds(0.5f);

        // Switch off the bricks
        m_AudioSource.pitch = 1f;
        m_AudioSource.PlayOneShot(m_EndSound);
        foreach (Brick b in m_Bricks)
        {
            b.SwitchOff(false);
        }

        yield return new WaitForSeconds(5f);

        Fade.Instance.InstantIn();
        m_ScoreScreen.SetActive(true);
        Fade.Instance.Out(0.5f);
        yield return new WaitForSeconds(1f);
        
        // Get levels data
        int size = 0;
        ProgressData.LevelData[] levelsData = GameManager.Instance.GameData.GetLevelsData(out size);

        // Show levels data
        // -> Intro
        m_LVL0Name.text = "Introduction";
        m_LVL0Name.enabled = true;
        m_LVL0Score.text = "Score : " + levelsData[0].BestScore;
        m_LVL0Score.enabled = true;
        int time = levelsData[0].BestTime;
        int min = time / 60;
        time -= (min * 60);
        m_LVL0Time.text = "Temps : " + min + "m" + time + "s";
        m_LVL0Time.enabled = true;
        yield return new WaitForSeconds(0.5f);

        // -> Level 1
        m_LVL1Name.text = "Niveau 1";
        m_LVL1Name.enabled = true;
        m_LVL1Score.text = "Score : " + levelsData[1].BestScore;
        m_LVL1Score.enabled = true;
        time = levelsData[1].BestTime;
        min = time / 60;
        time -= (min * 60);
        m_LVL1Time.text = "Temps : " + min + "m" + time + "s";
        m_LVL1Time.enabled = true;
        yield return new WaitForSeconds(0.5f);

        // -> Level 2
        m_LVL2Name.text = "Niveau 2";
        m_LVL2Name.enabled = true;
        m_LVL2Score.text = "Score : " + levelsData[2].BestScore;
        m_LVL2Score.enabled = true;
        time = levelsData[2].BestTime;
        min = time / 60;
        time -= (min * 60);
        m_LVL2Time.text = "Temps : " + min + "m" + time + "s";
        m_LVL2Time.enabled = true;
        yield return new WaitForSeconds(0.5f);

        // -> Level 3
        m_LVL3Name.text = "Niveau 3";
        m_LVL3Name.enabled = true;
        m_LVL3Score.text = "Score : " + levelsData[3].BestScore;
        m_LVL3Score.enabled = true;
        time = levelsData[3].BestTime;
        min = time / 60;
        time -= (min * 60);
        m_LVL3Time.text = "Temps : " + min + "m" + time + "s";
        m_LVL3Time.enabled = true;
        yield return new WaitForSeconds(0.5f);
        
        // -> TOTAL
        m_TotalScore.text = "Score final : " + GameManager.Instance.GameData.Score;
        m_TotalScore.enabled = true;
        yield return new WaitForSeconds(0.5f);
        time = GameManager.Instance.GameData.PlayTime;
        min = time / 60;
        time -= (min * 60);
        m_TotalTime.text = "Temps total : " + min + "m" + time + "s";
        m_TotalTime.enabled = true;
        yield return new WaitForSeconds(1f);

        m_EnterForQuit.text = "Appuyez sur Entrée pour revenir au menu principal";
        m_EnterForQuit.enabled = true;

        // Wait for player pushing Entry
        while (!InputManager.Instance.GetMenuInputStatus(InputSettings.MenuInputs.OK))
        {
            yield return 0;
        }
        m_Finished = true;
    }
}