﻿using UnityEngine;
using System.Collections;

public class CheckpointModel : MonoBehaviour
{
    public Transform m_Arrow;
    public Particle m_Particles;
    public Color m_Current;
    public Color m_NotCurrent;

    private Animator m_Animator;

    void OnEnable()
    {
        m_Animator = GetComponent<Animator>();
    }

    public void Appear()
    {
        m_Animator.SetBool("Appear", true);
        SetCurrent(true);
    }

    public void SetCurrent(bool current)
    {
        if (current) m_Arrow.renderer.material.color = m_Current;
        else m_Arrow.renderer.material.color = m_NotCurrent;
    }
}