﻿using UnityEngine;
using System.Collections;

public class PauseMenu : Menu
{
    private int m_FuturResult;
    private Camera m_Camera;

    public override void Initialize()
    {
        base.Initialize();
        m_Camera = GetComponentInChildren<Camera>();
        m_CurrentScreen = m_FirstScreen;
        StartCoroutine("C_Initialize");
    }

    private IEnumerator C_Initialize()
    {
        yield return new WaitForSeconds(0.5f);
        Show();
    }

    public override int UpdateMenu()
    {
        if (InputManager.Instance.GetMouseClic(0))
        {
            Ray ray = m_Camera.ScreenPointToRay(InputManager.Instance.GetMousePosition());
            RaycastHit info;
            if (Physics.Raycast(ray, out info))
            {
                MenuButton mb = info.transform.GetComponent<MenuButton>();
                if (mb != null)
                {
                    if (mb.LinkedScreen != null)
                    {
                        Debug.Log("New screen : " + mb.LinkedScreen.name);
                        // Hide the current screen
                        m_CurrentScreen.Hide();

                        // Get the linked screen
                        m_CurrentScreen = mb.LinkedScreen;

                        // Show the linked one
                        StartCoroutine("C_ScreenTransition");
                    }
                    else
                    {
                        m_FuturResult = mb.Result;
                        Hide();
                    }
                }
            }
        }
        return base.UpdateMenu();
    }

    private IEnumerator C_ScreenTransition()
    {
        yield return new WaitForSeconds(1f);
        m_CurrentScreen.Show();
    }

    public override void Show()
    {
        base.Show();
        m_CurrentScreen.Show();
    }

    public override void Hide()
    {
        base.Hide();
        // Hide the current screen
        m_CurrentScreen.Hide();
        StartCoroutine("C_Hide");
    }

    private IEnumerator C_Hide()
    {
        // Wait for hidding animation
        yield return new WaitForSeconds(1f);

        // Set the result (to send it to the GameManager during the next Update)
        m_Result = m_FuturResult;
    }
}