﻿using UnityEngine;
using System.Collections;

public class MainMenu : Menu
{
    private int m_FuturResult;
    public Light m_Light;
    private MainMenuEyes[] m_Eyes;
    public MainMenuCam m_Camera;

    private Brick[] m_Bricks;
    public Color m_BrickColor;

    void Awake()
    {
        GameManager gm = GameManager.Instance;
        m_Eyes = FindObjectsOfType(typeof(MainMenuEyes)) as MainMenuEyes[];
        m_Bricks = FindObjectsOfType(typeof(Brick)) as Brick[];
        foreach (Brick b in m_Bricks)
        {
            b.SetColor(m_BrickColor);
        }
        m_CurrentScreen = m_FirstScreen;
    }

    public override void Initialize()
    {
        base.Initialize();
        StartCoroutine("C_Initialize");
    }

    private IEnumerator C_Initialize()
    {
        yield return new WaitForSeconds(1f);
        Show();
    }

    public override int UpdateMenu()
    {
        if (InputManager.Instance.GetMouseClic(0))
        {
            Ray ray = Camera.main.ScreenPointToRay(InputManager.Instance.GetMousePosition());
            RaycastHit info;
            if (Physics.Raycast(ray, out info))
            {
                MenuButton mb = info.transform.GetComponent<MenuButton>();
                if (mb != null)
                {
                    if (mb.LinkedScreen != null)
                    {
                        //Debug.Log("New screen : " + mb.LinkedScreen.name);
                        // Hide the current screen
                        m_CurrentScreen.Hide();

                        // Get the linked screen
                        m_CurrentScreen = mb.LinkedScreen;
                        
                        // Show the linked one
                        StartCoroutine("C_ScreenTransition");
                    }
                    else
                    {
                        m_FuturResult = mb.Result;
                        Hide();
                    }
                }
            }
        }
        return base.UpdateMenu();
    }

    private IEnumerator C_ScreenTransition()
    {
        yield return new WaitForSeconds(1f);
        m_CurrentScreen.Show();
    }

    public override void Show()
    {
        base.Show();
        m_CurrentScreen.Show();
    }

    public override void Hide()
    {
        base.Hide();
        StartCoroutine("C_Hide");
    }

    private IEnumerator C_Hide()
    {
        // Hide the current screen
        m_CurrentScreen.Hide();

        // Wait during the current screen hidding => don't need it
        //yield return new WaitForSeconds(0.5f);

        // Switch off the light
        m_Light.GetComponent<MainMenuLight>().SwitchOff(0.7f);
        // Make eyes appear
        foreach (MainMenuEyes eyes in m_Eyes)
        {
            eyes.Appear(Random.Range(1f, 1.5f), Random.Range(0.5f, 1.5f));
        }

        // Wait for animation
        yield return new WaitForSeconds(1f);
        foreach (Brick b in m_Bricks)
        {
            b.SwitchOff();
        }
        //m_Camera.StopMoving();
        yield return new WaitForSeconds(1.5f);

        // Fade in
        Fade.Instance.In(0.5f);

        // Wait for fadding
        yield return new WaitForSeconds(0.5f);

        // Set the result (to send it to the GameManager during the next Update)
        m_Result = m_FuturResult;
    }
}