using UnityEngine;
using System.Collections;

public class DeviceController
{
	// Id
	private int m_Id;
	public int Id
	{
		get { return m_Id; }
	}
	// Device name
	private string m_Name;
	public string Name
	{
		get { return m_Name; }
	}
	// Device type
	private InputSettings.Devices m_Type;
	public InputSettings.Devices Type
	{
		get { return m_Type; }
	}
	// Player
	private int m_Player;
	public int Player
	{
		get { return m_Player; }
		set { m_Player = value; }
	}
	// Is it currently used ?
	private float m_UsedTimer;
	protected float m_TimeToBeUsed;
	protected bool m_UsedThisFrame;
	private bool m_IsUsed;
	public bool IsUsed
	{
		get { return m_IsUsed; }
		set { m_IsUsed = value; }
	}
	public bool IsUsedCurrenly
	{
		get
		{
			if(m_UsedThisFrame)
			{
				m_UsedThisFrame = false;
				m_UsedTimer += Time.deltaTime;
				if(m_UsedTimer > m_TimeToBeUsed)
				{
					m_UsedTimer = 0f;
					return true;
				}
				return false;
			}
			else
			{
				m_UsedTimer = 0f;
				return false;
			}
		}
	}
	
	// Movements status
	protected float[] m_MovementsStatus;
	// Actions status
	protected InputSettings.ActionStatus[] m_ActionsStatus;
	// Menu inputs status
	protected bool[] m_MenuStatus;
	
	#region Constructor
	public DeviceController(int id, string name, InputSettings.Devices type)
	{
		m_Id = id;
		m_Name = name;
		m_Type = type;
		m_UsedThisFrame = false;
		m_UsedTimer = 0f;
	}
	#endregion
	
	#region Update
	public virtual void UpdateController()	
	{
	}
	#endregion
	
	#region Movements
	// Getter
	public virtual float GetAxisValue(InputSettings.Movements axis)
	{
		return 0f;
	}
	
	// Setter
	public virtual void UpdateAxis()
	{
	}
	#endregion
	
	#region Actions
	// Getter
	public virtual bool GetActionStatus(InputSettings.Actions action, InputSettings.ActionStatus status)
	{
		return false;
	}
	
	// Setter
	public virtual void UpdateActions()
	{
	}
	#endregion
	
	#region Menu inputs
	// Getter
	public virtual bool GetMenuInputStatus(InputSettings.MenuInputs input)
	{
		return false;
	}
	
	public virtual Vector3 GetMousePosition()
	{
		return Input.mousePosition;
	}

    public virtual bool GetMouseClic(int clic)
    {
        return Input.GetMouseButtonDown(clic);
    }
	
	// Setter
	public virtual void UpdateMenuInputs()
	{
	}
	#endregion
}