using UnityEngine;
using System.Collections;

public class Axis 
{
	// Axis name
	private string m_Name;
	public string Name
	{
		get { return m_Name; }
		set { m_Name = value; }
	}
	// Axis keys
	private Key m_PositiveKey;
	public Key PositiveKey
	{
		get { return m_PositiveKey; }
		set { m_PositiveKey = value; }
	}
	private Key m_NegativeKey;
	public Key NegativeKey
	{
		get { return m_NegativeKey; }
		set { m_NegativeKey = value; }
	}
	// Inversed axe ?
	private bool m_Invert;
	
	#region Contructors
	public Axis(string name)
	{
		m_Name = name;
		m_PositiveKey = new Key();
		m_NegativeKey = new Key();
		m_Invert = false;
	}
	
	public Axis(string name, bool invert)
	{
		m_Name = name;
		m_PositiveKey = new Key();
		m_NegativeKey = new Key();
		m_Invert = invert;
	}
	
	public Axis(Key positive, Key negative)
	{
		m_Name = null;
		m_PositiveKey = positive;
		m_NegativeKey = negative;
		m_Invert = false;
	}
	
	public Axis(Key positive, Key negative, bool invert)
	{
		m_Name = null;
		m_PositiveKey = positive;
		m_NegativeKey = negative;
		m_Invert = invert;
	}
	
	public Axis(KeyCode positiveKeyCode, KeyCode negativeKeyCode)
	{
		m_Name = null;
		m_PositiveKey = new Key(positiveKeyCode);
		m_NegativeKey = new Key(negativeKeyCode);
		m_Invert = false;
	}
	
	public Axis(KeyCode positiveKeyCode, KeyCode negativeKeyCode, bool invert)
	{
		m_Name = null;
		m_PositiveKey = new Key(positiveKeyCode);
		m_NegativeKey = new Key(negativeKeyCode);
		m_Invert = invert;
	}
	#endregion
	
	#region Getters
	public float GetValue()
	{
		float result = 0f;
		
		if(StringUtils.IsEmptyString(m_Name))
		{
			if(m_PositiveKey.GetKeyDown() || m_PositiveKey.GetKeyPressed())
			{
				result += 1f;
			}
			
			if(m_NegativeKey.GetKeyDown() || m_NegativeKey.GetKeyPressed())
			{
				result -= 1f;
			}
		}
		else
		{
			// TO DO : axe défini par son nom (joystick)
			
			if(m_Invert)
			{
				result = -result;
			}
		}
		
		return result;
	}
	#endregion
}
