using UnityEngine;
using System.Collections;

public class LookAtTarget : MonoBehaviour 
{
	// Hero transform
	private Transform m_HeroModel;
	// Target transform
	private Transform m_Target;
	// Last position
	private Vector3 m_LastPosition;
	// Avancement
	private float m_Avancement;
	// Speed
	public float m_Speed = 2f;
	
	public float m_TimeToWait;
	private float m_WaitTimer;

    public Vector3 m_Offset;
	
	void Awake()
	{
        m_HeroModel = GameObject.Find("Hero/VirusModel/Modelisation").transform;
		m_Target = transform;
        m_Target.position = m_HeroModel.position + m_Offset;
        m_LastPosition = m_HeroModel.position + m_Offset;
		m_Avancement = 0f;
		m_WaitTimer = 0f;
	}
	
	void Update()
	{
        if (m_HeroModel.position + m_Offset != m_LastPosition)
		{
			if(m_WaitTimer < m_TimeToWait)
			{
				m_WaitTimer += Time.deltaTime;
				if(m_WaitTimer > m_TimeToWait)
				{
					m_Avancement = 0f;
				}
			}
			else
			{
				if(m_Avancement < 0.2f) m_Avancement += Time.deltaTime * 0.5f;
                m_Target.position = Vector3.Lerp(m_Target.position, m_HeroModel.position + m_Offset, m_Avancement);
			}
		}
		else
		{
			m_WaitTimer = 0f;
			if(m_Avancement < 1f) m_Avancement += Time.deltaTime;
            m_Target.position = Vector3.Lerp(m_Target.position, m_HeroModel.position + m_Offset, m_Avancement);
		}

        m_LastPosition = m_HeroModel.position + m_Offset;
	}
}