﻿using UnityEngine;
using System.Collections;

public class HiddenPlace : InteractiveElement
{
    public Transform m_HiddenPositionTransform;
    public Transform m_UnhidePositionTransform;
    private bool m_CanHide;

    protected override void OnEnable()
    {
        base.OnEnable();
    }

    protected override void Start()
    {
        base.Start();
        m_CanHide = false;
        m_InteractionType = ElementSettings.InteractionType.Hide;
    }

    public override bool UpdateElement()
    {
        // Virus not already used
        if (!m_Used)
        {
            if(!m_CanHide && m_Trigger.IsIn)
            {
                m_CanHide = true;
                m_Trigger.InteractCharacter.CharacterCanUseSomething(true, this);
            }
            else if (m_CanHide && !m_Trigger.IsIn)
            {
                m_CanHide = false;
                m_Trigger.InteractCharacter.CharacterCanUseSomething(false, null);
            }
        }

        return false;
    }

    public override void UseIt()
    {
        // Hide
        if (!m_Used)
        {
            m_Trigger.InteractCharacter.MustGoSomewhere(m_HiddenPositionTransform.position, 0.5f);
            m_Used = true;
        }
            // Unhide
        else
        {
            m_Trigger.InteractCharacter.MustGoSomewhere(m_UnhidePositionTransform.position, 0.5f);
            m_Used = false;
        }
    }
}