﻿using UnityEngine;
using System.Collections;

public class CollectibleElement : Element
{
    public int m_Points;
    protected bool m_Collected;
    protected InteractTrigger m_Trigger;

    protected override void Start()
    {
        base.Start();
        m_Trigger = GetComponentInChildren<InteractTrigger>();
    }

    public override bool UpdateElement()
    {
        if (m_Trigger.IsIn)
        {
            TakeIt();
        }
        return base.UpdateElement();
    }

    public override int SaveStatus()
    {
        if (!gameObject.activeSelf && !m_Collected)
        {
            m_Collected = true;
            return m_ID;
        }
        return base.SaveStatus();
    }

    public override void ReInit()
    {
        if (!m_Collected)
        {
            gameObject.SetActive(true);
        }
    }

    protected virtual void TakeIt()
    {
        gameObject.SetActive(false);
        GameManager.Instance.EarnPoints(m_Points);
    }
}