﻿using UnityEngine;
using System.Collections;

public class Brick : MonoBehaviour 
{
    public AnimationCurve m_LightingCurve;

	void Start()
    {
        //renderer.material.color = Color.black;
	}

    #region Switch on/off
    public void SwitchOff()
    {
        SwitchOff(true);
    }

    public void SwitchOff(bool immediate)
    {
        if (immediate) SetColor(Color.black);
        else
        {
            StartCoroutine(C_SwitchOff(Random.Range(0.5f, 2f), Random.Range(0.5f, 2f)));
        }
    }

    public void Illumin()
    {
        Illumin(true);
    }

    public void Illumin(bool onlyVisible)
    {
        if (!onlyVisible || renderer.isVisible)
        {
            StartCoroutine(C_Illumin(Random.Range(0.5f, 2f), Random.Range(0.5f, 2f)));
        }
        else
        {
            SetColor(Color.white);
        }
    }

    private IEnumerator C_SwitchOff(float tmp, float speed)
    {
        yield return new WaitForSeconds(tmp);

        float timer = 0f;
        while (timer < 1f)
        {
            SetColor(Color.Lerp(Color.white, Color.black, m_LightingCurve.Evaluate(timer)));
            timer += Time.deltaTime * speed;
            yield return 0;
        }

        SetColor(Color.black);
    }

    private IEnumerator C_Illumin(float tmp, float speed)
    {
        yield return new WaitForSeconds(tmp);

        float timer = 0f;

        while (timer < 1f)
        {
            SetColor(Color.Lerp(Color.black, Color.white, m_LightingCurve.Evaluate(timer)));
            timer += Time.deltaTime * speed;
            yield return 0;
        }

        SetColor(Color.white);
    }
    #endregion

    public void SetColor(Color color)
    {
        color.a = 0.6f;
        renderer.material.color = color;
    }

    public void Alert()
    {
        if (renderer.isVisible)
        {
            SetColor(Color.red);
        }
    }

    public void ReInit()
    {
        SetColor(Color.white);
    }
}