using UnityEngine;
using System.Collections;

public class Hero_Motor : Character_Motor
{
	private static Vector3 m_AskedMovement;
	public static Vector3 AskedMovement
	{
		get { return m_AskedMovement; }
	}
	private static Vector3 m_Heroposition;
	public static Vector3 HeroPosition
	{
		get { return m_Heroposition; }
	}

    private CharacterController m_CharController;

    // Grounded
    public override bool isGrounded
    {
        get { return m_CharController.isGrounded; }
    }

    public void Initialize(Transform character, CharacterController controller, Character_Animator animator, Character_Physic physic)
    {
        m_CharController = controller;
        base.Initialize(character, animator, physic);
    }
	
	#region Update
    // Gravity
    protected override void ApplyGravity()
    {
        // Reapply vertical velocity
        if (m_IsOnPlatform)
        {
            if (!m_CanMoveOnPlatform)
            {
                m_MoveVector = Vector3.zero;
            }
            m_MoveVector += m_Platform.DeltaMove;
            return;
        }

        m_MoveVector.Set(m_MoveVector.x, m_VerticalVelocity, m_MoveVector.z);

        if (m_Jump)
            return;

        // Character's falling
        else if (!m_CharController.isGrounded)
        {
            if (m_MoveVector.y > -m_MaxVelocity)
            {
                m_MoveVector = new Vector3(m_MoveVector.x, m_MoveVector.y - m_FallSpeed * Time.deltaTime, m_MoveVector.z);
            }
        }
        else if (m_MoveVector.y < 0f)
        {
            m_MoveVector = new Vector3(m_MoveVector.x, -0.01f, m_MoveVector.z);
        }
    }

    protected override void ApplyMovement()
    {
        Vector3 tmp = m_MoveVector;
        tmp.y = 0f;
        m_CharController.Move(m_MoveVector);
    }
	#endregion
	
	#region Events
    public override void Jump()
    {
        if (m_CharController.isGrounded && !m_Jump)
        {
            m_VerticalVelocity = 0;
            m_Jump = true;
            StartCoroutine("C_Jump");
        }
    }

    private IEnumerator C_Jump()
    {
        // We use the cosinus function
        float timer = 0f;
        float lastHeight = 0f;
        float jumpSpeed2PI2 = Mathf.PI / 2f / m_JumpSpeed;
        bool wallOn = false;
        do
        {
            m_VerticalVelocity = (Mathf.Sin(timer * jumpSpeed2PI2) * m_JumpHeight) - lastHeight;
            m_MoveVector.y = m_VerticalVelocity;
            lastHeight += m_VerticalVelocity;
            timer += Time.deltaTime;
            wallOn = m_CharacterPhysic.WallOnHead();
            yield return 0;
        }
        while (timer <= m_JumpSpeed && !wallOn);
        //while (!m_CharController.isGrounded && timer <= m_JumpSpeed && !wallOn);

        m_VerticalVelocity = -0.01f;
        m_MoveVector.y = m_VerticalVelocity;
        m_Jump = false;
    }
	#endregion
}