using UnityEngine;
using System.Collections;

public class Hero_Controller
{
	// Hero motor
	private Hero_Motor m_Motor;
	// hero interaction manager
	private Hero_Interaction m_Interaction;
	
	// Constructor
	public Hero_Controller(Hero_Motor motor)
	{
		m_Motor = motor;
		m_Interaction = new Hero_Interaction();
	}
	
	#region Update
	public void UpdateController()
	{
		GetLocomotionInput();
		HandleActionInput();
	}
	#endregion

	#region Movements
	private void GetLocomotionInput()
	{
		float h = InputManager.Instance.GetAxisValue(InputSettings.Movements.Horizontal2D);
		float v = InputManager.Instance.GetAxisValue(InputSettings.Movements.Vertical2D);
        if (m_Interaction.CanHide)
        {
            m_Motor.MoveVector = new Vector3(h, v, 0f);
        }
        else if (m_Interaction.Hidden)
        {
            m_Motor.MoveVector = new Vector3(0f, v, 0f);
        }
		else m_Motor.MoveVector = new Vector3(h,0f,0f);
		float speed = Mathf.Abs(h);
		if(speed > 1f) speed = 1f;
		//Hero_Animator.Instance.SetSpeed(speed);
	}
	#endregion
	
	#region Actions
	private void HandleActionInput()
	{
		// Jump
		if(InputManager.Instance.GetActionStatus(InputSettings.Actions.Jump, InputSettings.ActionStatus.Down))
		{
			m_Motor.Jump();
		}

        // Attack
        if (InputManager.Instance.GetActionStatus(InputSettings.Actions.Attack, InputSettings.ActionStatus.Down))
        {
            // TODO : Hero_Interaction
        }

        // Corruption
        if (InputManager.Instance.GetActionStatus(InputSettings.Actions.Corruption, InputSettings.ActionStatus.Down))
        {
            // TODO : Hero_Interaction
        }

        // Interaction
        if (InputManager.Instance.GetActionStatus(InputSettings.Actions.Interact, InputSettings.ActionStatus.Down))
        {
            // TODO : Hero_Interaction
        }

        /*
		// Run
		if(InputManager.Instance.GetActionStatus(InputSettings.Actions.Sprint, InputSettings.ActionStatus.Down))
		{
			m_Motor.Run(true);
			//Hero_Animator.Instance.SetRun(true);
		}
		else if(InputManager.Instance.GetActionStatus(InputSettings.Actions.Sprint, InputSettings.ActionStatus.Up))
		{
			m_Motor.Run(false);
			//Hero_Animator.Instance.SetRun(false);
		}
         */
		
		// Pause
		if(InputManager.Instance.GetActionStatus(InputSettings.Actions.Pause, InputSettings.ActionStatus.Down))
		{
            GameManager.Instance.PauseGame(true);
		}

        // Hide
        //if (m_Interaction.CanHide && m_Motor.MoveVector.y > 0)
        if (m_Interaction.CanHide && m_Motor.MoveVector.y > 0)
        {
            m_Interaction.Interact();
        }
        else if (m_Interaction.Hidden && m_Motor.MoveVector.y < 0)
        {
            m_Interaction.Interact();
        }
	}
	#endregion

    #region Events
    public void ReInit()
    {
        m_Interaction.ReInit();
    }

    public void CanUseSomething(bool can, InteractiveElement element)
    {
        m_Interaction.HeroCanUseSomething(can, element);
    }
    #endregion
}