using UnityEngine;
using System.Collections;

public class Hero : Character
{
    private bool m_CanMove;
	protected Hero_Controller m_HeroController;
	
	public Vector3 HeroPosition
	{
		get { return m_CharacterModel.position; }
	}
	public Quaternion HeroOrientation
	{
		get { return m_CharacterModel.rotation; }
	}
	
	protected override void Start()
	{
		base.Start();
        m_CanMove = true;
		// Create the character motor
		m_CharacterAnimator = gameObject.AddComponent<Hero_Animator>();
		Hero_Physic heroPhysic = new Hero_Physic(m_CharacterModel, GetComponentInChildren<CharacterController>());
        Hero_Motor hm = gameObject.AddComponent<Hero_Motor>();
        hm.Initialize(m_CharacterModel, GetComponentInChildren<CharacterController>(), m_CharacterAnimator,heroPhysic);
        m_CharacterMotor = hm;
		//m_CharacterMotor = new Hero_Motor(m_CharacterModel,GetComponentInChildren<CharacterController>(), m_CharacterAnimator);
		m_Type = CharacterSettings.Type.Hero;
		m_SpawnOffset = Vector3.zero;
        m_HeroController = new Hero_Controller(m_CharacterMotor as Hero_Motor);
	}
	
	public override void UpdateCharacter()
	{
        // Save vertical velocity value
        m_CharacterMotor.ReinitMoveVector();

        // Controller update
        if (m_CanMove) m_HeroController.UpdateController();

        // Motor update
        m_CharacterMotor.UpdateMotor();
    }

    #region Events
    public override void Spawn(Vector3 position)
    {
        m_HeroController.ReInit();
        base.Spawn(position);
    }

    public override void CharacterCanMove(bool can)
    {
        m_CanMove = can;
    }

    public override void CharacterCanUseSomething(bool can, InteractiveElement element)
    {
        m_HeroController.CanUseSomething(can, element);
    }
    #endregion
}