﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class AntiSpyCam : Enemy
{
    // Ray sources
    public Light m_Light;
    public Texture m_GreenLight;
    public Texture m_RedLight;
    public Transform[] m_RaySources;
    private Ray[] m_View;

    protected override void Start()
    {
        base.Start();
        m_View = new Ray[m_RaySources.Length];

        for(int i = 0; i<m_View.Length; ++i)
        {
            m_View[i] = new Ray();
        }
    }

    // Update is called once per frame
    public override void UpdateCharacter()
    {
        base.UpdateCharacter();

        RaycastHit hitInfo;
        foreach (Ray ray in m_View)
        {
            if (Physics.Raycast(ray, out hitInfo, Mathf.Infinity, LayersUtils.HeroLayerWithOcclusion))
            {
                //Debug.Log("Test : " + hitInfo.transform.name);
                if (hitInfo.transform.gameObject.layer == LayersUtils.HeroLayerMask)
                {
                    // Stop its routine
                    m_Routine.StopRoutine();
                    // Light is red !
                    m_CharacterModel.renderer.materials[2].SetTexture("_MainTex", m_RedLight);
                    m_Light.color = Color.red;
                    // Inform the GameManager
                    GameManager.Instance.Lost(-m_Dammage);
                }
            }
        }

        // Define rays
        for (int i = 0; i < m_View.Length; ++i)
        {
            m_View[i].origin = m_RaySources[i].position;
            m_View[i].direction = m_RaySources[i].up;

            Debug.DrawRay(m_View[i].origin, m_View[i].direction, Color.red, 0.1f);
        }
    }

    public override void ReInit()
    {
        base.ReInit();
        m_Light.color = Color.green;
        m_CharacterModel.renderer.materials[2].SetTexture("_MainTex", m_GreenLight);
    }

    public override void Spawn(Vector3 position)
    {
    }
}