﻿using UnityEngine;
using System.Collections;

public class menu_script : MonoBehaviour {
	
	
	//logo_splashScreen
	public Texture2D logo;
	
	//sound
	public AudioSource snd_btn;
	public AudioSource music_Menu;
	float volMusic = 0.6f;
	
	//button skins
	public GUISkin btnStart;
	public GUISkin btnLevel;
	public GUISkin btnQuit;
	
	
	//loadscreen
	public GUISkin loadingGUI;
	
	
	bool delayer = false;
	
	
	//LEVELS GUI
	
	public Texture2D levelsTitle;
	
	public GUISkin gui_btn0s;
	public GUISkin gui_btn1s;
	public GUISkin gui_btn2s;
	public GUISkin gui_btn3s;
	public GUISkin gui_btnlock;
	public GUISkin btn_lvl_menu;
	
	public static int starsLevel1 = 0;
	public static int starsLevel2 = -1;
	public static int starsLevel3 = -1;
	public static int starsLevel4 = -1;
	public static int starsLevel5 = -1;
	public static int starsLevel6 = -1;
	
	
	//Delayed Method
	delegate void DelayedMethod();
	IEnumerator WaitAndDo(float time, DelayedMethod method)
	{
	    yield return new WaitForSeconds(time);
	    method();
	}

	// Use this for initialization
	void Start () {
		
	}
	
	// Update is called once per frame
	void Update () {
	
	}
	
	void OnGUI(){
		switch(game.currentstate){
			case "splashscreen":
				SplashScreen();
				break;
			case "menuscreen":
				MenuScreen();
				break;
			case "levelscreen":
				LevelScreen();
				break;
			case "loadscreen":
				fadeOut();
				LoadScreen();
				break;
		}
	}
	
	void SplashScreen(){
		
		GUI.DrawTexture(new Rect((Screen.width-(411*0.6f))/2, Screen.height/3, 411*0.6f, 307*0.6f), logo, ScaleMode.StretchToFill, true, 10.0F);
		
		if(delayer == false){
			StartCoroutine(WaitAndDo(2, changeState));
			delayer = true;
		}
	}
	
	void MenuScreen(){
		GUI.DrawTexture(new Rect((Screen.width-(249))/2, Screen.height/8, 249, 186), logo, ScaleMode.StretchToFill, true, 10.0F);
		GUI.skin = btnStart;
		if(GUI.Button(new Rect((Screen.width-300)/2, Screen.height/2.3f, 303, 99), "")){
			snd_btn.Play();
			Application.LoadLevel(""+levelManager.currentLevel);
			game.currentstate ="loadscreen";
		}
		GUI.skin = btnLevel;
		if(GUI.Button(new Rect((Screen.width-300)/2, (Screen.height/2.3f)+94, 303, 99), "")){
			snd_btn.Play();
			game.currentstate ="levelscreen";
		}
		GUI.skin = btnQuit;
		if(GUI.Button(new Rect((Screen.width-300)/2, (Screen.height/2.3f)+188, 303, 99), "")){
			snd_btn.Play();
			Application.Quit();
		}		
		
	}
	
	void changeState(){
		if(game.currentstate == "splashscreen"){
			game.currentstate = "menuscreen";
		}
		if(game.currentstate == "introlevel"){
			game.currentstate = "instructions";	
		}
		if(game.currentstate == "congrats"){
			game.currentstate = "scoreScreen";
		}
		delayer = false;
	}
	
	void changeStateInst(){
		if(game.currentstate == "instructions"){
			game.currentstate = "playingGame";
		}
		delayer = false;
	}
	
	void LoadScreen(){
		
		//GUI.DrawTexture(new Rect((Screen.width-(249))/2, Screen.height/6, 249, 186), logo, ScaleMode.StretchToFill, true, 10.0F);
		GUI.skin = loadingGUI;
		GUI.Label(new Rect(0, 0, Screen.width, Screen.height),"loading...");
	}
	
	
	
	void LevelScreen(){
		GUI.DrawTexture(new Rect((Screen.width-(199))/2, Screen.height/25, 199, 149), levelsTitle, ScaleMode.StretchToFill, true, 10.0F);
		
		switch(starsLevel1){
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;
		}
		if(GUI.Button(new Rect(Screen.width/2-226, Screen.height/3-20, 144, 143), "1")){
			snd_btn.Play();
			Application.LoadLevel("1");
			levelManager.currentLevel = 1;
			game.currentstate ="loadscreen";
		}
		
		switch(starsLevel2){
			case -1:	GUI.skin = gui_btnlock;break;
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;
		}
		if(GUI.Button(new Rect(Screen.width/2-72, Screen.height/3-20, 144, 143), "2")){
			if(starsLevel2>=0){
				snd_btn.Play();
				Application.LoadLevel("2");
				levelManager.currentLevel = 2;
				game.currentstate ="loadscreen";
			}
		}
		
		switch(starsLevel3){
			case -1:	GUI.skin = gui_btnlock;break;
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;;
		}
		if(GUI.Button(new Rect(Screen.width/2+82, Screen.height/3-20, 144, 143), "3")){
			if(starsLevel3>=0){
				snd_btn.Play();
				Application.LoadLevel("3");
				levelManager.currentLevel = 3;
				game.currentstate ="loadscreen";
			}
		}
		
		switch(starsLevel4){
			case -1:	GUI.skin = gui_btnlock;break;
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;
		}
		if(GUI.Button(new Rect(Screen.width/2-226, Screen.height/3 + 128, 144, 143), "4")){
			if(starsLevel4>=0){
				snd_btn.Play();
				Application.LoadLevel("4");
				levelManager.currentLevel = 4;
				game.currentstate ="loadscreen";
			}
		}
		
		switch(starsLevel5){
			case -1:	GUI.skin = gui_btnlock;break;
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;
		}
		if(GUI.Button(new Rect(Screen.width/2-72, Screen.height/3 + 128, 144, 143), "5")){
			if(starsLevel5>=0){
				snd_btn.Play();
				Application.LoadLevel("5");
				levelManager.currentLevel = 5;
				game.currentstate ="loadscreen";
			}
		}
		
		switch(starsLevel6){
			case -1:	GUI.skin = gui_btnlock;break;
			case 0:	GUI.skin = gui_btn0s;break;
			case 1:	GUI.skin = gui_btn1s;break;
			case 2:	GUI.skin = gui_btn2s;break;
			case 3: GUI.skin = gui_btn3s;break;
		}
		if(GUI.Button(new Rect(Screen.width/2+82, Screen.height/3 + 128, 144, 143), "6")){
			if(starsLevel6>=0){
				snd_btn.Play();
				Application.LoadLevel("6");
				levelManager.currentLevel = 6;
				game.currentstate ="loadscreen";
			}
		}
		
		GUI.skin = btn_lvl_menu;
		if(GUI.Button(new Rect(Screen.width/2-152, Screen.height/3 + 290, 304, 99), "")){
			snd_btn.Play();
			game.currentstate = "menuscreen";
		}
	}
	
	
	
	void fadeIn() {
    	if(music_Menu.volume <= 0.6f){
        	volMusic += 0.2f * Time.deltaTime;
        	snd_btn.volume = volMusic;
	    }
	}
 
	void fadeOut() {
    	if(music_Menu.volume > 0.1f){
	        volMusic -= 0.2f * Time.deltaTime;
	        snd_btn.volume = volMusic;
	    }
	}
}
