﻿using UnityEngine;
using System.Collections;

public class game : MonoBehaviour {
	
	public AudioSource fleche_sound;
	public AudioSource shot_sound;
	public AudioSource long_shot_sound;
	
	bool flcplayed = false;
	
	public Color FlechecolorStart = Color.green;
    public Color FlechecolorEnd = Color.red;
	
	public static string currentstate = "splashscreen";
	
	public GameObject placementIndicator;
	public GameObject endplacementIndicator;
	public GameObject fleche;
	GameObject myfleche;
	
	public GameObject FloggyNorm;
	public GameObject posinit01;
	
	//bool FloggyDisplayed = false;
	
	bool indicInit = false;
	bool endInit = false;
	
	Vector3 posinit;
	Vector3 posfin;
	float distance;
	
	Vector3 direction;
	
	
	
	
	public static int nbShots = 0;
	
	
	Vector3 puissance;
	
	
	bool hitted = false;
	
	// Use this for initialization
	void Start () {
		
	}
	
	// Update is called once per frame
	void Update () {
		switch(currentstate){
			case "playingGame":
				StartPlaying();
				break;
			case "init":
				funcInit();
				break;
		}
	}
	
	void StartPlaying(){
			
			Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
		    RaycastHit hit;
			
		    if (Physics.Raycast(ray, out hit, 1000) && hit.normal.y > 0.999){
			
				if(indicInit == false && FloggyNorm.rigidbody.IsSleeping()){
					placementIndicator.SetActive(true);
					placementIndicator.transform.position = new Vector3(hit.point.x, 0.02f, hit.point.z);
				}
		       	if(indicInit == true && endInit == false){
					endplacementIndicator.SetActive(true);
			   		endplacementIndicator.transform.position = new Vector3(hit.point.x, 0.02f, hit.point.z);
					distance = Vector3.Distance(posinit, hit.point);
					myfleche.transform.localScale = new Vector3(1f,0.01f,distance/1.80f);
				
				//Debug.Log(distance);
					
				if(distance>1.5f){
					if(!fleche_sound.isPlaying && flcplayed==false){
						fleche_sound.Play();
						fleche_sound.volume = 100;
						flcplayed=true;
					}
				}
					var targetdir = posinit - hit.point;
					var dist = targetdir.magnitude;
					direction = targetdir / dist;
					
					myfleche.transform.forward = new Vector3 (direction.x, 0, direction.z);
					myfleche.renderer.material.color = Color.Lerp(FlechecolorStart, FlechecolorEnd, distance/7);
				}			
		    }
			if(Input.GetMouseButtonDown(0)){
				if(Input.mousePosition.x < Screen.width-100){
					posinit = hit.point;
					//Debug.Log("posinit = "+posinit);
					indicInit = true;
					myfleche = (GameObject)Instantiate(fleche,new Vector3(posinit.x+0.1f , posinit.y+0.1f , posinit.z), Quaternion.identity);
					myfleche.transform.localScale = new Vector3(0,0,0);
					hitted = false;
					
				}
				
			}
			if(Input.GetMouseButtonUp(0)){
				if(Input.mousePosition.x < Screen.width-100){
					posfin = hit.point;
					if(hitted == false){
						nbShots++;
						hitted = true;
					}
					
					Destroy(myfleche);
					
					puissance = direction * distance * 800;
					//Debug.Log(puissance);
				
					if(puissance.z < -6000){
						FloggyNorm.rigidbody.AddForce(puissance.x, 0, -6000);
					}
					else if(puissance.z > 6000){
						FloggyNorm.rigidbody.AddForce(puissance.x, 0, 6000);
					}
				
					else{
						FloggyNorm.rigidbody.AddForce(puissance.x, 0, puissance.z);
					}
				if(fleche_sound.isPlaying){
					fleche_sound.Stop();
					
				}
					
					if(puissance.z < -2500 || puissance.z > 2500){
						long_shot_sound.Play();
						long_shot_sound.volume = 60;
					}
					else if(puissance.z > -2500 || puissance.z < 2500){
						shot_sound.Play();
						shot_sound.volume = 60;
					}
					
					FloggyNorm.transform.forward = direction;
					
					indicInit = false;
					endInit = false;
					flcplayed=false;
				}
			else{
				Destroy(myfleche);
				indicInit = false;
				endInit = false;
				flcplayed=false;
			}
				
			}
		
		//Floggy is moving
		if(!FloggyNorm.rigidbody.IsSleeping()){
			placementIndicator.SetActive(false);
			endplacementIndicator.SetActive(false);
		}
		
	}
	
	
	void funcInit(){
		
		fireworks_script.isEmited = false;
		FloggyNorm.rigidbody.velocity = Vector3.zero;
        FloggyNorm.rigidbody.angularVelocity = Vector3.zero;
		FloggyNorm.transform.position = posinit01.transform.position;
		FloggyNorm.transform.forward = posinit01.transform.forward;
		nbShots = 0;
		//coin_script.nbCoins = 0;
		currentstate = "introlevel";
	}
	
	
}