﻿using UnityEngine;
using System.Collections;

public class GuiLevel : MonoBehaviour {
	
	//sounds
	public AudioSource floggy_snd01;
	public AudioSource floggy_snd02;
	public AudioSource floggy_snd03;
	public AudioSource enemy_snd01;
	public AudioSource snd_btn;
	public AudioSource achatlock_snd;
	
	//display tuto or not
	bool delayer = false;
	public static bool firstTime_lvl1 = true;
	public static bool firstTime_lvl2 = true;
	public static bool firstTime_lvl4 = true;
	public static bool firstTime_lvl5 = true;
	public static bool firstTime_lvl6 = true;
	
	
	//GUI img
	public Texture2D background;
	public Texture2D shotsBg;
	public Texture2D pictoCoins;
	public Texture2D boul_img;
	
	//GUI skins
	public GUISkin playingGUI;
	public GUISkin canonGUI;
	public GUISkin haloGUI;
	public GUISkin btnRestartPlaying;
	public GUISkin btnMenuPlaying;
	public GUISkin vol_on;
	public GUISkin vol_off;
	
	//tutoriels
	public Texture2D tuto01;
	public Texture2D tuto02;
	public Texture2D tuto03;
	public Texture2D tuto05;
	public Texture2D tuto06;
	
	//Spower	
	public GameObject canon;
	public GameObject halo;
	public ParticleEmitter fumee;
	
	
	
	
	delegate void DelayedMethod();
	IEnumerator WaitAndDo(float time, DelayedMethod method)
	{
	    yield return new WaitForSeconds(time);
	    method();
	}

	// Use this for initialization
	void Start () {
		transform.Rotate(24.5f, -180f, 0f, Space.World);
		game.currentstate = "introlevel";
		game.nbShots = 0;
		if(canon){
			canon.SetActive(false);
		}
		if(halo){
			halo.SetActive(false);
		}
	}
	
	// Update is called once per frame
	void Update () {
		
	}
	
	void DrawQuad(Rect position, Color color) {
		Texture2D texture = new Texture2D(1, 1);
		texture.SetPixel(0, 0, color);
		texture.Apply();
		GUI.skin.box.normal.background = texture;
		GUI.Box(position, GUIContent.none);
	}
	
	void OnGUI(){
		switch(game.currentstate){
			case "introlevel":
				IntroLevel();
				break;
			case "instructions":
				displayInstruction();
				break;
			case "playingGame":
				gameGUI();
				break;
			case "congrats":
				congratsScreen();
				break;
		}
	}
	
	void changeState(){
		if(game.currentstate == "introlevel"){
			game.currentstate = "instructions";	
		}
		if(game.currentstate == "congrats"){
			Application.LoadLevel("scorescene");
		}
		delayer = false;
	}
	
	void changeStateInst(){
		if(game.currentstate == "instructions"){
			switch (levelManager.currentLevel){
				case 1 : firstTime_lvl1 = false;	break;
				case 2 : firstTime_lvl2 = false;	break;
				case 4 : firstTime_lvl4 = false;	break;
				case 5 : firstTime_lvl5 = false;	break;
				case 6 : firstTime_lvl6 = false;	break;
			}
			game.currentstate = "playingGame";
		}
		delayer = false;
	}
	
	void IntroLevel(){
		if(delayer == false){
			StartCoroutine(WaitAndDo(3, changeState));
			delayer = true;
		}
	}
	
	bool played = false;
	
	void displayInstruction(){
		switch (levelManager.currentLevel){
			case 1 :
				levelManager.nbSPower = 0;
				if(firstTime_lvl1 == true){
					if(!floggy_snd01.isPlaying && played==false){
						floggy_snd01.Play();
						floggy_snd01.volume=450;
						played=true;
					}
					GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), tuto01);
					StartCoroutine(WaitAndDo(4, changeStateInst));
				}
				else if(firstTime_lvl1 == false){
					changeStateInst();
				}
				break;
			case 2 :
				levelManager.nbSPower = 0;
				if(firstTime_lvl2 == true){
					if(!enemy_snd01.isPlaying && played==false){
						enemy_snd01.Play();
						played=true;
					}
					GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), tuto02);
					StartCoroutine(WaitAndDo(4, changeStateInst));
				}
				else if(firstTime_lvl2 == false){
					changeStateInst();
				}
				break;
			case 3 :
				levelManager.nbSPower = 0;
				if(!floggy_snd02.isPlaying && played==false){
					floggy_snd02.Play();
					played=true;
				}
				changeStateInst();
				break;
			case 4 :
				levelManager.nbSPower = 1;
				if(firstTime_lvl4 == true){
					if(!floggy_snd03.isPlaying && played==false){
						floggy_snd03.Play();
						played=true;
					}
					GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), tuto03);
					StartCoroutine(WaitAndDo(5, changeStateInst));
				}
				else if(firstTime_lvl4 == false){
					changeStateInst();
				}
				break;
			case 5 :
				levelManager.nbSPower = 2;
				if(firstTime_lvl5 == true){
					if(!floggy_snd02.isPlaying && played==false){
						floggy_snd02.Play();
						played=true;
					}
					GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), tuto05);
					StartCoroutine(WaitAndDo(5, changeStateInst));
				}
				else if(firstTime_lvl5 == false){
					changeStateInst();
				}
				break;
			case 6 :
				levelManager.nbSPower = 2;
				if(firstTime_lvl6 == true){
					if(!enemy_snd01.isPlaying && played==false){
						enemy_snd01.Play();
						played=true;
					}
					GUI.DrawTexture(new Rect(0, 0, Screen.width, Screen.height), tuto06);
					StartCoroutine(WaitAndDo(4, changeStateInst));
				}
				else if(firstTime_lvl6 == false){
					changeStateInst();
				}
				break;
		}
	}
	
	void gameGUI(){
		GUI.skin = playingGUI;
		GUI.DrawTexture(new Rect(0, 0, 162, 91), shotsBg, ScaleMode.StretchToFill, true, 0.0F); 
		GUI.Label(new Rect(90, 15, 70, 70),""+game.nbShots);
		
		
		//menu droite
		GUI.DrawTexture(new Rect(Screen.width-100, 0, 100, Screen.height), background); 
		GUI.DrawTexture(new Rect(Screen.width-90, 20, 19, 30), pictoCoins, ScaleMode.StretchToFill, true, 0.0F);
		GUI.Label(new Rect(Screen.width-50, 5, 70, 70),""+coin_script.nbCoinsGen);
		
		
		//superPowers
		
		for(int i= 0; i<levelManager.nbSPower; i++){
			switch(i){
				case 0:
					//achat canon
					GUI.skin = canonGUI;
					if(GUI.Button(new Rect(Screen.width-88,80 , 76, 76), "")){
						if(coin_script.nbCoinsGen>=2){
							if(canon.activeInHierarchy == false){
								FeedbackGUI.currentFeedback = "achat";
								snd_btn.Play();
								Spower.numBoulet = 5;
								fumee.transform.position = canon.transform.position;
								fumee.Emit();
								canon.SetActive(true);
								coin_script.nbCoinsGen = coin_script.nbCoinsGen-2;
								floggy_snd03.Play();
							}
						}
						else {
							FeedbackGUI.currentFeedback = "achatlock";
							achatlock_snd.Play();
						}
					}
					break;
				case 1:
					//achat halo
					GUI.skin = haloGUI;
					if(GUI.Button(new Rect(Screen.width-88,165 , 76, 76), "")){
						if(coin_script.nbCoinsGen>=3){
							if(halo.activeInHierarchy == false){
								FeedbackGUI.currentFeedback = "achatHalo";
								snd_btn.Play();
								fumee.transform.position = halo.transform.position;
								fumee.Emit();
								halo.SetActive(true);
								halo_script.HaloCurrentState = "active";
								coin_script.nbCoinsGen = coin_script.nbCoinsGen-3;
								floggy_snd02.Play();
								StartCoroutine(WaitAndDo(5, changeStateHalo));
							}
						}
						else {
							FeedbackGUI.currentFeedback = "achatlock";
							achatlock_snd.Play();
						}
					}
					break;
			}
		}
		
		if(levelManager.currentLevel>=4 && canon.activeInHierarchy == true){
			for(int i= 0; i<Spower.numBoulet; i++){
				GUI.DrawTexture(new Rect((Screen.width-160)-i*51, 10, 41, 41), boul_img);
			}
		}
		
		//main btn menu
		GUI.skin = btnRestartPlaying;
		if(GUI.Button(new Rect(Screen.width-90,100+levelManager.nbSPower*90 , 80, 80), "")){
			snd_btn.Play();
			Application.LoadLevel(""+levelManager.currentLevel);
		}
		
		GUI.skin = btnMenuPlaying;
		if(GUI.Button(new Rect(Screen.width-90,200+levelManager.nbSPower*90 , 80, 80), "")){
			snd_btn.Play();
			game.currentstate="menuscreen";
			Application.LoadLevel("main_menu");
		}
		
		switch(levelManager.VolisMute){
			case false:
				GUI.skin = vol_on;
				if(GUI.Button(new Rect(Screen.width-90,300+levelManager.nbSPower*90 , 80, 80), "")){
					MuteSound();
				}
				break;
			case true:
				GUI.skin = vol_off;
				if(GUI.Button(new Rect(Screen.width-90,300+levelManager.nbSPower*90 , 80, 80), "")){
					MuteSound();
				}
				break;
		}
		
	}
	
	void congratsScreen(){
		FeedbackGUI.currentFeedback = "endLevel";
		StartCoroutine(WaitAndDo(2, changeState));
	}
	
	void MuteSound(){
		if(levelManager.VolisMute == false){
			AudioListener.volume = 0;
			levelManager.VolisMute = true;
		}
		else{
			AudioListener.volume = 1;
			levelManager.VolisMute = false;
		}
		
	}
	
	void changeStateHalo(){
		if(halo.activeInHierarchy == true){
			halo_script.HaloCurrentState ="destroy";
		}
		
	}
	
	
	
}