﻿using UnityEngine;
using System.Collections;

public class Move : MonoBehaviour {
	public static float speed = 6.0f;
	
	public float crouchDeltaHeight = 0.5f;
	float nextCrouchTime = 0.0f;
	bool crouching = false;
	bool stop_crouching = false;
	float nextJumpTime = 0.0f;
	public Camera camera;
	public GameObject level;
	
	public GameObject player;
	public BoxCollider playerCollider;
	
	
delegate void DelayedMethod();
 
	IEnumerator WaitAndDo(float time, DelayedMethod method)
	{
	    yield return new WaitForSeconds(time);
	    method();
	}
		
	void Start(){
		camera = Camera.main;
	}

 
	// Update is called once per frame
	void Update () 
	{
		//masque la souris
		
		
		//courir en permanence
		transform.Translate(-Vector3.forward*Time.deltaTime*speed,Space.World);
		
		
		
		//en crabe sur les cotés
		if (Input.GetKey(KeyCode.Q) && player.transform.position.x < 1.9f)
		{
			player.transform.Translate(-transform.right*Time.deltaTime*speed,Space.World);
		}
		if (Input.GetKey(KeyCode.D) && player.transform.position.x > -1.9f)
		{
			player.transform.Translate(transform.right*Time.deltaTime*speed,Space.World);
		}
		
		//S'accroupir
		if (Input.GetKeyDown(KeyCode.S) && Time.time > nextCrouchTime){
				nextCrouchTime = Time.time + 1.5f;
		        crouch();
		}
		
		if(crouching){
			camera.transform.Translate(new Vector3(0, -1.0f, 0) * Time.deltaTime * 2);
		}
		
		if(stop_crouching){
			camera.transform.Translate(new Vector3(0, +1.0f, 0) * Time.deltaTime * 2);
		}
		
		//Sauter
		if (Input.GetKeyDown(KeyCode.Space) && Time.time > nextJumpTime){
				nextJumpTime = Time.time + 1.5f;
				player.rigidbody.AddForce(0,400.0f,0);
			
		}

	}
	
	    void crouch() {
		//player
		Debug.Log("crouch");
	        playerCollider.size -= new Vector3(0,crouchDeltaHeight, 0);
		playerCollider.center -= new Vector3(0.0f,crouchDeltaHeight/2, 0.0f);
			
		crouching = true;

		StartCoroutine(WaitAndDo(0.5f, StopCrouching));
    }
	
		public void StopCrouching()
	{
	    playerCollider.size += new Vector3(0,crouchDeltaHeight, 0);
		playerCollider.center += new Vector3(0.0f,crouchDeltaHeight/2, 0.0f);
		//camera.transform.Translate(0, 0.4f, 0 * Time.deltaTime);
			crouching = false;
		stop_crouching = true;
		StartCoroutine(WaitAndDo(0.5f, StopMoveCrouching));
		
	}
	
		public void StopMoveCrouching()
	{
		stop_crouching = false;
		
	}
	


}
