﻿using UnityEngine;
using System.Collections;
using System.Collections.Generic;



public class GameState : MonoBehaviour {
	public static string gameState;
	public GameObject player;
	public GameObject sceptre;
	public string playerName = "Name";
	public GameObject death;
	
	public GameObject checkpoints;
	public GameObject checkpoint;
	public static bool checkpoint_active;
	public GameObject PorteEntree;
	public GameObject SolClear;
	public GameObject PorteSimple;
	public GameObject PorteTriple;
	public GameObject PorteHexa;
	public GameObject Win;
	private GameObject module;
	private float distance = -30.6f;
	private bool level_loaded = false;
	
	private float alarm_start;
	public GameObject text_score;
	public GameObject text_champion;
	
	public Texture2D viseur;
	public Texture2D curseur;
	public GUISkin PortalRunSkin;
	public float MenuX = (2*Screen.width)/3;
	
	public Texture2D lvl1_illu;
	public Texture2D lvl2_illu;
	public Texture2D lvl3_illu;
	
	public Texture2D lvl1_win;
	public Texture2D lvl2_win;
	
	//Level variables
	public GameObject cadenas1;
	public GameObject cadenas2;
	
	public Material HoverMat;
	public Material OutMat;
	
	public static int maxColors;
	public static bool level_chosen = false;
	public static int deblockedLevel = 0;
	public static int current_level;
	private List<string> current_level_array;
	public List<List<string>> level_array;
	public static List<string> level1;
	public static List<string> level2;
	public static List<string> level3;
	public static List<string> level_unlimited;
	private bool unlimited_start;
	
	
	// Use this for initialization
	void Start () {
		gameState = "menu";
		GetComponent<TimeRecord>().enabled = false;
		player.GetComponent<Move>().enabled = false;
		player.transform.Rotate(new Vector3(0,-20,0));
		//PlayerPrefs.SetFloat("High Score", 0.0f);
		text_score.GetComponent<TextMesh>().text = FormatTime(PlayerPrefs.GetFloat("High Score"));
		text_champion.GetComponent<TextMesh>().text = PlayerPrefs.GetString("High Score Player");
		
		level1 = new List<string>{"clear","clear","porteSimple","clear","porteSimple", "porteSimple","clear","porteSimple","Win"};
		level2 = new List<string>{"clear","clear","porteTriple","clear","porteSimple", "porteTriple","clear","porteTriple", "porteSimple", "Win"};
		level3 = new List<string>{"clear","clear","porteTriple","porteTriple","porteTriple","clear", "porteHexa","porteSimple","clear","porteHexa","porteTriple","clear","porteSimple","Win"};
		level_unlimited = new List<string>{"clear","clear","clear","porteSimple","porteSimple","porteSimple","porteTriple","porteTriple","porteHexa","porteHexa"};
		level_array = new List<List<string>>{level1,level2,level3};
	}
	
delegate void DelayedMethod();
 
	IEnumerator WaitAndDo(float time, DelayedMethod method)
	{
	    yield return new WaitForSeconds(time);
	    method();
	}
	
	// Update is called once per frame
	void Update () {	
		switch(gameState){
		case "menu":
			print(PlayerPrefs.GetFloat("High Score"));
			WaitForLevel();
			break;
		case "rules":
			break;
		case "game":
			pauseGame();
			StartGame();
			break;
		case "dead":
			break;
		}
	}
	
	public void WaitForLevel(){
		
		if(sceptre.animation.IsPlaying("walk")){
			sceptre.animation.Stop("walk");
		}
		if(GetComponent<TimeRecord>().enabled){
			GetComponent<TimeRecord>().enabled = false;
		}
		if(player.GetComponentInChildren<Fire>().enabled){
			player.GetComponentInChildren<Fire>().enabled = false;
		}
		if(!player.GetComponent<MouseLook>().enabled && !Camera.main.GetComponent<MouseLook>().enabled){
		player.GetComponent<MouseLook>().enabled = true;
		Camera.main.GetComponent<MouseLook>().enabled = true;
		}
		Screen.showCursor = false;
	    RaycastHit hit = new RaycastHit();
	    if (Physics.Raycast (Camera.main.transform.position, Camera.main.transform.forward, out hit, 1000000.0f)) {
			//si bouton visé
			if(hit.collider.gameObject.layer == 10){
				//trouve tous les boutons
				GameObject[] list_button = FindGameObjectsWithLayer(10);
				for (int i = 0; i < list_button.Length; i++) {
					//attribue le hover au bouton visé
					if(list_button[i] == hit.collider.gameObject){
						hit.collider.gameObject.renderer.material.SetColor("_SpecColor", Color.white);
						//hit.collider.gameObject.renderer.material = HoverMat;
					} 
					//met aux autres le matériel out
					else {
						list_button[i].renderer.material.SetColor("_SpecColor", Color.black);
						//list_button[i].renderer.material. = OutMat;
					}
				}
				//si clique lance le niveau associé au tag du bouton visé
				if(Input.GetMouseButtonDown(0)){
					current_level = int.Parse(hit.collider.gameObject.tag);
					if(current_level <= deblockedLevel || current_level == 6){
						gameState = "rules";	
					} else {
						//add feedback level blocked
					}
				}
			}
		}		
		
		if(level_chosen){
					level_chosen = true;
					levelLoad(level_array[current_level]);
					level_chosen = false;
		}
	}

	//trouve les boutons
	GameObject[] FindGameObjectsWithLayer (int layer) {
		GameObject[] goArray = FindObjectsOfType(typeof(GameObject)) as GameObject[];
		List<GameObject> goList = new List<GameObject>();
		for (int i = 0; i < goArray.Length; i++) {
		   if (goArray[i].layer == layer) {
		     goList.Add(goArray[i]);
		   }
		}
		if (goList.Count == 0) {
		   return null;
		}
		return goList.ToArray();
	}

	
	
	public void levelLoad(List<string> level){
		
		if(level == level1){
			maxColors = 1;
		} else if (level == level2){
			print ("DEUXIEME NIVEAU");
			maxColors = 2;
		} else {
			maxColors = 3;	
		}

		for (int i = 0; i < level.Count; i++)
				{
				    string s = level[i];	
					switch(s){
					case "clear":
						module = SolClear;
						break;
						
					case "porteSimple":
						module = PorteSimple;
						break;
						
					case "porteTriple":
						module = PorteTriple;
						break;
						
					case "porteHexa":
						module = PorteHexa;
						break;
				
					case "Win":
						module = Win;
						break;
					}
					GameObject module_clone = (GameObject)Instantiate(module, new Vector3(0f,2f,distance), Quaternion.identity);
					module_clone.transform.parent = transform;
					distance -= 10f;
		
				}
		level_loaded = true;
		distance = -30.6f;
		alarm_start = Time.time + 3.0f;
		gameState = "game";
	}
	
	public void levelLoadUnlimited(List<string> level){
		maxColors = 3;	
		for (int i = 0; i < 11; i++)
				{
					if(i<9){
					int m = Random.Range(0,9);
				    string s = level[m];	
					switch(s){
					case "clear":
						module = SolClear;
						break;
						
					case "porteSimple":
						module = PorteSimple;
						break;
						
					case "porteTriple":
						module = PorteTriple;
						break;
						
					case "porteHexa":
						module = PorteHexa;
						break;
					}
					GameObject module_clone = (GameObject)Instantiate(module, new Vector3(0f,2f,distance), Quaternion.identity);
					module_clone.transform.parent = transform;
					} else if(i==9) {
					GameObject module_clone = (GameObject)Instantiate(SolClear, new Vector3(0f,2f,distance), Quaternion.identity);
					module_clone.transform.parent = checkpoints.transform;
					} else {
					GameObject module_clone = (GameObject)Instantiate(checkpoint, new Vector3(0f,2f,distance), Quaternion.identity);
					module_clone.transform.parent = checkpoints.transform;
				}
					distance -= 10f;
		
				}
		if(unlimited_start){
			level_loaded = true;
			alarm_start = Time.time + 3.0f;
			unlimited_start = false;
		}
		gameState = "game";
	}
	
	void pauseGame(){
		
		if (Input.GetKeyDown(KeyCode.KeypadEnter)){
			if(player.GetComponent<Move>().enabled){
			player.GetComponent<Move>().enabled = false;
			} else {
			player.GetComponent<Move>().enabled = true;	
			}
			
		}
	}
	
	void OnGUI () {
		switch(gameState){
		case "menu":
			GUI.DrawTexture(new Rect(Screen.width/2-32,Screen.height/2-32,64,64),viseur);
			break;
		case "rules":
			guiRules();
			break;
		case "game":
			guiStartGame();
			break;		
		case "win":
			guiWin();
			break;			
		case "dead":
			guiDead();
			break;
		}
	}
	
	void guiRules(){
		Cursor.SetCursor(curseur,Vector2.zero,CursorMode.ForceSoftware);
		string title = "";
		string description = "";
		Texture2D illu = lvl1_illu;
		
		switch(current_level){
		case 0:
			title = "First Level";
			description = "Shoot the gems to open the doors and reach a new power.";
			illu = lvl1_illu;
			break;
		case 1:
			title = "Second Level";
			description = "Strafe left or right with Q & D to avoid the spikes";
			illu = lvl2_illu;
			break;
		case 2:
			title = "Third Level";
			description = "Jump with space and crouch with S to avoid the spikes";
			illu = lvl3_illu;
			break;
		case 6:
			title = "Unlimited";
			description = "Challenge yourself in a infinite level and try to last as long as possible.";
			break;
		}
		Screen.showCursor = true;
		
		if(player.GetComponent<MouseLook>().enabled && Camera.main.GetComponent<MouseLook>().enabled){
			player.GetComponent<MouseLook>().enabled = false;
			Camera.main.GetComponent<MouseLook>().enabled = false;
		}
		
		GUI.BeginGroup(new Rect(2*(Screen.width/3)+3, 40, Screen.width/3, Screen.height-80), "");
		GUI.Box(new Rect(0, 0, Screen.width/3, Screen.height-80),"", PortalRunSkin.FindStyle("box"));
		GUI.Label(new Rect(Screen.width/6 - 150, 10, 300, 40), title, PortalRunSkin.FindStyle("Title"));


        GUI.Label(new Rect(Screen.width/6 - 150, 80, 300, 100), description, PortalRunSkin.FindStyle("label"));
		
		if(current_level<6){
			GUI.DrawTexture(new Rect(0,160,320,292),illu);
		}
		
		if (GUI.Button(new Rect(0, Screen.height-130, Screen.width/6, 50), "Start Level", PortalRunSkin.FindStyle("button"))){
			
			//load level
			if(current_level == 6){
				unlimited_start = true;
				levelLoadUnlimited(level_unlimited);
			} else {
				levelLoad (level_array[current_level]);
			}
			//alarm_start = Time.time + 3.0f;
			//gameState = "game";
		}
		if (GUI.Button(new Rect(Screen.width/6, Screen.height-130, Screen.width/6, 50), "Cancel", PortalRunSkin.FindStyle("button"))){
			gameState = "menu";
		}
		GUI.EndGroup();
		
	}
	

	void guiDead(){
		
		string title = "Game Over";
		string description = "Be faster next time, try to beat " + PlayerPrefs.GetString("High Score Player") +" with "+ FormatTime(PlayerPrefs.GetFloat("High Score"));
		
		Screen.showCursor = true;
		sceptre.animation.Stop("walk");
		if(player.GetComponent<MouseLook>().enabled && Camera.main.GetComponent<MouseLook>().enabled){
			player.GetComponent<MouseLook>().enabled = false;
			Camera.main.GetComponent<MouseLook>().enabled = false;
		}
		
		GUI.BeginGroup(new Rect((Screen.width)/2 - Screen.width/6, Screen.height/2-Screen.height/4, Screen.width/3, Screen.height/2), "");
		GUI.Box(new Rect(0, 0, Screen.width/3, Screen.height),"", PortalRunSkin.FindStyle("box"));
		GUI.Label(new Rect(Screen.width/6 - 150, 10, 300, 40), title, PortalRunSkin.FindStyle("Title"));
		GUI.Label(new Rect(Screen.width/6 - 150, 30, 300, 100), description, PortalRunSkin.FindStyle("label"));
		
		//si unlimited mode
		if(current_level == 6){
			TimeRecord.stopRecordingTime = true;
			
			// bat le high score
			if(PlayerPrefs.GetFloat("High Score")<TimeRecord.scoreTime || PlayerPrefs.GetFloat("High Score") == 0.0f){
				GUI.Label(new Rect(Screen.width/6 - 150, 50, 300, 100), "You beat the high score! Enter your name", PortalRunSkin.FindStyle("label"));
				playerName = GUI.TextField(new Rect(Screen.width/6 - 50, Screen.height/4, 100, 20), playerName, 8, PortalRunSkin.FindStyle("textfield"));
			}
		}

        
		
		if (GUI.Button(new Rect(0, Screen.height/2-50, Screen.width/6, 50), "Restart", PortalRunSkin.FindStyle("button"))){
			Reset();
			//load level
			if(current_level == 6){
				//stop timer
				GetComponent<TimeRecord>().enabled = false;
				//set score
				SetScore();
				//start unlimited
				unlimited_start = true;
				TimeRecord.stopRecordingTime = false;
				//reset speed
				Move.speed = 6.0f;
				//load firt blocks
				levelLoadUnlimited(level_unlimited);
			} else {
				levelLoad (level_array[current_level]);
			}
			//alarm_start = Time.time + 3.0f;
			//gameState = "game";
		}
		if (GUI.Button(new Rect(Screen.width/6, Screen.height/2-50, Screen.width/6, 50), "Back to menu", PortalRunSkin.FindStyle("button"))){
			if(current_level == 6){
				GetComponent<TimeRecord>().enabled = false;
				TimeRecord.stopRecordingTime = false;
				Move.speed = 6.0f;
				SetScore();
			}
			current_level = -1;
			Reset();
			gameState = "menu";
		}
		GUI.EndGroup();
		
	}
	
	void SetScore(){
			distance = -30.6f;
			if(PlayerPrefs.GetFloat("High Score") != 0.0f){
				if(PlayerPrefs.GetFloat("High Score")<TimeRecord.scoreTime){
					PlayerPrefs.SetString("High Score Player", playerName);
					PlayerPrefs.SetFloat("High Score", TimeRecord.scoreTime);
					text_score.GetComponent<TextMesh>().text = FormatTime(TimeRecord.scoreTime);
					text_champion.GetComponent<TextMesh>().text = playerName;
				}
			} else {
				PlayerPrefs.SetString("High Score Player", playerName);
				PlayerPrefs.SetFloat("High Score", TimeRecord.scoreTime);
				text_champion.GetComponent<TextMesh>().text = playerName;
				text_score.GetComponent<TextMesh>().text = FormatTime(TimeRecord.scoreTime);
			}
		
	}
	


	string FormatTime(float fTime)
	{			
	  System.TimeSpan t =  System.TimeSpan.FromSeconds( fTime );
	 
	  /// You can add more digits by adding more digits eg: {1:D2}:{2:D2}:{3:D2}:{4:D2} to also display milliseconds.
	  return string.Format("{1:D2}:{2:D2}", t.Hours, t.Minutes, t.Seconds, t.Milliseconds);
	}
	
	void guiWin(){
		string title = "You made it!";
		string description = "";
		Texture2D nouveau_pouvoir = lvl1_win;
		
		switch(current_level){
		case 0:
			description = "You won a new power! Hit \"2\" to use it in game to shoot the blue gems";
			nouveau_pouvoir = lvl1_win;
			break;
		case 1:
			description = "You won a new power! Hit \"3\" to use it in game to shoot the yellow gems";
			nouveau_pouvoir = lvl2_win;
			break;
		case 2:
			description = "You just finished tutorial mode! Now challenge yourself with the Unlimited mode";
			break;
		}
		sceptre.animation.Stop("walk");
	
		Screen.showCursor = true;
		
		if(player.GetComponent<MouseLook>().enabled && Camera.main.GetComponent<MouseLook>().enabled){
			player.GetComponent<MouseLook>().enabled = false;
			Camera.main.GetComponent<MouseLook>().enabled = false;
		}
		
		GUI.BeginGroup(new Rect((Screen.width)/2 - Screen.width/6, Screen.height/2-Screen.height/4, Screen.width/3, Screen.height/2), "");
		GUI.Box(new Rect(0, 0, Screen.width/3, Screen.height),"", PortalRunSkin.FindStyle("box"));
		GUI.Label(new Rect(Screen.width/6 - 150, 10, 300, 40), title, PortalRunSkin.FindStyle("Title"));


        GUI.Label(new Rect(Screen.width/6 - 150, 80, 300, 100), description, PortalRunSkin.FindStyle("label"));
		
		if(current_level<2){
			GUI.DrawTexture(new Rect(0,140,320,125),nouveau_pouvoir);
		}
		
		if(current_level<2){
		if (GUI.Button(new Rect(0, Screen.height/2-50, Screen.width/6, 50), "Next Level", PortalRunSkin.FindStyle("button"))){
			//debloque le level suivant si pas fait
			if(deblockedLevel == current_level){
				deblockedLevel++;
				print ("Avancée dans le jeu : " + deblockedLevel);
				if(deblockedLevel==1){
					Destroy(cadenas1);	
				}
				if(deblockedLevel==2){
					Destroy(cadenas2);	
				}
			}
			current_level ++;
			Reset();
			//load level
			alarm_start = Time.time + 3.0f;
			gameState = "rules";
		}
		}
		if (GUI.Button(new Rect(Screen.width/6, Screen.height/2-50, Screen.width/6, 50), "Back to menu", PortalRunSkin.FindStyle("button"))){
			if(deblockedLevel == current_level){
				deblockedLevel++;
				print ("Avancée dans le jeu : " + deblockedLevel);
				if(deblockedLevel==1){
					Destroy(cadenas1);	
				}
				if(deblockedLevel==2){
					Destroy(cadenas2);	
				}
			}
			current_level = -1;
			Reset();
			gameState = "menu";
		}
		GUI.EndGroup();
	}
	
	public void Reset(){
			death.transform.position = new Vector3(0f,5.75f,-25f);
			player.transform.position = new Vector3(0f,3f,-5f);
			Instantiate(PorteEntree, new Vector3(0f,6.8f,-30.5f), Quaternion.identity);
			death.collider.enabled = false;
			
			//destroy level
			foreach (Transform child in transform)
			{
			  Destroy(child.gameObject);
			}
			
			foreach (Transform child in checkpoints.transform)
			{
			  Destroy(child.gameObject);
			}
	}
	
	public void ResetUnlimited(){
			//destroy level
			foreach (Transform child in transform)
			{
			  Destroy(child.gameObject);
			}
		float playerZ = player.transform.position.z;
		death.transform.position = new Vector3(0f,5.7f,playerZ + 5f);
			levelLoadUnlimited(level_unlimited);
	}
	
	
	public void StartGame(){
		Screen.showCursor = false;
		if(!player.GetComponent<MouseLook>().enabled && !Camera.main.GetComponent<MouseLook>().enabled){
		player.GetComponent<MouseLook>().enabled = true;
		Camera.main.GetComponent<MouseLook>().enabled = true;
		}
		
		if(level_loaded){
			if (alarm_start < Time.time){
				player.GetComponent<Move>().enabled = true;
				sceptre.animation.Play("walk");
				player.GetComponentInChildren<Fire>().enabled = true;
				level_loaded = false;
			}
		}
		//UNLIMITED
		if(checkpoint_active){
			ResetUnlimited();
			checkpoint_active = false;
		}
		//DEATH FOLLOW
		if(player.transform.position.z < -30){
			death.collider.enabled = true;
			death.transform.Translate(-Vector3.forward*Time.deltaTime*Move.speed,Space.World);
		}
	}
	
	public void guiStartGame(){
		GUI.DrawTexture(new Rect(Screen.width/2-32,Screen.height/2-32,64,64),viseur);
			if (alarm_start < Time.time){
				if(alarm_start > Time.time-2f){
					GUI.Label(new Rect(Screen.width/2-25, Screen.height/3-25, 50, 50), "Go!",PortalRunSkin.GetStyle("Title"));
					
				if(current_level == 6){
					GetComponent<TimeRecord>().enabled = true;
				}
			}
			} else {
				GUI.Label(new Rect(Screen.width/2-50, Screen.height/3-25, 100, 50), "Ready ...",PortalRunSkin.GetStyle("Title"));
			}
	}
}
