﻿using UnityEngine;
using System.Collections;

public class Fire : MonoBehaviour {
	public GameObject BulletPrefab;
	public GameObject IcePrefab;
	public GameObject FirePrefab;
	public GameObject ElecPrefab;
	
	public GameObject spawn_bullet;

	public GameObject IceMarker;
	public GameObject FireMarker;
	public GameObject ElecMarker;
	
	public Material IceMat;
	public Material FireMat;
	public Material ElecMat;
	public Material NoneIce;
	public Material NoneFire;
	public Material NoneElec;

	float nextFireTime = 0.0f;
	// Update is called once per frame
	
	void Start(){
		//Fire first
		FireMarker.renderer.material = FireMat;
	}
	void Update () {

		
		//Choosing weapon
		if(Input.GetKeyDown(KeyCode.Alpha1)){
			BulletPrefab = FirePrefab;
			FireMarker.renderer.material = FireMat;
			IceMarker.renderer.material = NoneIce;
			ElecMarker.renderer.material = NoneElec;
		}
		if(Input.GetKeyDown(KeyCode.Alpha2)){
			if(GameState.deblockedLevel>0 || GameState.current_level ==6){
				BulletPrefab = IcePrefab;
				IceMarker.renderer.material = IceMat;
				FireMarker.renderer.material = NoneFire;
				ElecMarker.renderer.material = NoneElec;
			}
		}
		if(Input.GetKeyDown(KeyCode.Alpha3)){
			if(GameState.deblockedLevel>1 || GameState.current_level ==6){
				BulletPrefab = ElecPrefab;
				ElecMarker.renderer.material = ElecMat;
				IceMarker.renderer.material = NoneIce;
				FireMarker.renderer.material = NoneFire;
			}
		}
		if(Input.GetMouseButtonDown(0) && Time.time > nextFireTime){
			nextFireTime = Time.time + 0.5f;
			//Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);
			GameObject.Find("gush_mesh").animation["fire"].layer = 1;
			GameObject.Find("gush_mesh").animation.Play("fire");
			Debug.Log(transform.position);
			Instantiate(BulletPrefab, spawn_bullet.transform.position, spawn_bullet.transform.rotation);
		}
	}
}
