using UnityEngine;
using System.Collections;

[System.Serializable]
public class Vect4f
{
	// xMin
	public float m_xMin;
	public float xMin
	{
		get { return m_xMin; }
		set
		{
			m_xMin = value;
			m_Center.x = (m_xMin+m_xMax)*0.5f;
			m_Size.x = m_xMax-m_xMin;
		}
	}
	// xMax
	public float m_xMax;
	public float xMax
	{
		get { return m_xMax; }
		set
		{
			m_xMax = value;
			m_Center.x = (m_xMin+m_xMax)*0.5f;
			m_Size.x = m_xMax-m_xMin;
		}
	}
	public float m_yMin;
	public float yMin
	{
		get { return m_yMin; }
		set
		{
			m_yMin = value;
			m_Center.y = (m_yMin+m_yMax)*0.5f;
			m_Size.y = m_yMax-m_yMin;
		}
	}
	public float m_yMax;
	public float yMax
	{
		get { return m_yMax; }
		set
		{
			m_yMax = value;
			m_Center.y = (m_yMin+m_yMax)*0.5f;
			m_Size.y = m_yMax-m_yMin;
		}
	}
	// Center
	private Vector3 m_Center;
	public Vector3 Center
	{
		get { return m_Center; }
	}
	// Size
	private Vector3 m_Size;
	public Vector3 Size
	{
		get { return m_Size; }
	}
	
	public Vect4f(float xmin, float xmax, float ymin, float ymax)
	{
		m_xMin = xmin;
		m_xMax = xmax;
		m_yMin = ymin;
		m_yMax = ymax;
		
		m_Center = new Vector3((m_xMin+m_xMax)*0.5f,0f,(m_yMin+m_yMax)*0.5f);
		m_Size = new Vector3(m_xMax-m_xMin,0f,m_yMax-m_yMin);
	}

    public Vect4f()
    {
        m_xMin = 0;
        m_xMax = 0;
        m_yMin = 0;
        m_yMax = 0;

        m_Center = Vector3.zero;
        m_Size = Vector3.zero;
    }
	
	// Get the best position if the camera is no more in the zone
	public bool Contains(ref Vector3 position)
	{
		bool result = true;
		
		if(position.x <= m_xMin)
		{
			position.x = m_xMin;
			result = false;
		}
		else if(position.x >= m_xMax)
		{
			position.x = m_xMax;
			result = false;
		}
		
		if(position.y <= m_yMin)
		{
			position.y = m_yMin;
			result = false;
		}
		else if(position.y >= m_yMax)
		{
			position.y = m_yMax;
			result = false;
		}
		
		return result;
	}
	
	public bool Contains(Vector3 position)
	{
		if(position.x >= m_xMin && position.x <= m_xMax
			&& position.y >= m_yMin && position.y <= m_yMax)
		{
			return true;
		}
		else return false;
	}

    public override string ToString()
    {
        return "xMin = " + m_xMin + ", xMax = " + m_xMax + ", yMin = " + m_yMin + ", yMax = " + m_yMax;
    }
}