﻿using UnityEngine;
using System.Collections;

public class CheckPoint : MonoBehaviour
{
    private int m_Order;
    public int Order
    {
        get { return m_Order; }
    }
    public int m_StoryStep;
    public int StoryStep
    {
        get { return m_StoryStep; }
    }
    public InteractTrigger m_Trigger;
    public Transform m_SpawnPoint;
    public Vector3 Position
    {
        get { return m_SpawnPoint.position; }
    }

    private bool m_Checked;
    private bool m_IsIn;
    private Element[] m_Elements;
    private Character[] m_Characters;

	void Start()
    {
        m_Trigger = GetComponentInChildren<InteractTrigger>();
        m_Elements = GetComponentsInChildren<Element>();
        m_Characters = GetComponentsInChildren<Character>();
        m_Checked = false;
        m_IsIn = false;
        m_Order = int.Parse(name.Replace("CheckPoint", ""));
	}

	void Update()
    {
        if (!m_IsIn)
        {
            if (m_Trigger.IsIn)
            {
                GameManager.Instance.NewCheckPoint(this);
                m_Checked = true;
                m_IsIn = true;
            }
        }
        else
        {
            if (!m_Trigger.IsIn)
            {
                m_IsIn = false;
            }
        }
	}

    public void SaveProgress()
    {
        if (!m_Checked)
            return;

        // TODO : Save elements status
        foreach (Element e in m_Elements)
        {
            e.SaveStatus();
        }

        // TODO : Save enemies status
        foreach (Character c in m_Characters)
        {

        }
    }

    public void UpdateProgress()
    {
        // TODO : Load elements initial (or saved) status
        foreach (Element e in m_Elements)
        {
            e.ReInit();
        }

        // Load enemies initial (or saved) status
        foreach (Character c in m_Characters)
        {
            c.ReInit();
        }
    }
}