﻿using UnityEngine;
using System.Collections;

public class CommonLevel : Level
{
    public Material BrickMaterial;
    private Material m_BrickMaterial;
    protected CheckPoint[] m_CheckPoints;
    protected Element[] m_Elements;
    protected Brick[] m_Bricks;

    #region Initialization
    protected override void Start()
    {
        base.Start();
        m_BrickMaterial = new Material(BrickMaterial);
        m_CheckPoints = GetComponentsInChildren<CheckPoint>();
        m_Elements = GetComponentsInChildren<Element>();
        m_Bricks = GetComponentsInChildren<Brick>();
    }

    public override void SetStoryProgress(int state)
    {
        base.SetStoryProgress(state);
    }
    #endregion

    public override void UpdateLevel()
    {
        base.UpdateLevel();
        foreach (Element e in m_Elements)
        {
            e.UpdateElement();
        }
    }

    #region Events
    public override void SaveProgress()
    {
        foreach (CheckPoint cp in m_CheckPoints)
        {
            cp.SaveProgress();
        }
    }

    public override void LoadProgress()
    {
        foreach (CheckPoint cp in m_CheckPoints)
        {
            cp.UpdateProgress();
        }

        foreach (Brick b in m_Bricks)
        {
            b.ReInit();
        }
    }

    public override void Lost()
    {
        foreach (Brick cube in m_Bricks)
        {
            cube.Alert();
        }
    }
    #endregion
}