using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class DeviceControllerConfig
{
	// Movements lists
	private List<Axis> m_Movements;
	private List<Axis> m_DefaultMouvements;
	// Actions lists
	private List<Key> m_Actions;
	private List<Key> m_DefaultActions;
	
	#region Contructors
	public DeviceControllerConfig(List<Axis> defaultAxis, List<Key> defaultActions)
	{
		m_DefaultMouvements = defaultAxis;
		m_DefaultActions = defaultActions;
		
		m_Movements = new List<Axis>();
		foreach(Axis axis in m_DefaultMouvements)
		{
			m_Movements.Add(axis);
		}
		
		m_Actions = new List<Key>();
		foreach(Key action in m_DefaultActions)
		{
			m_Actions.Add(action);
		}
	}
	#endregion
	
	#region Movements
	// Getter
	public float GetAxisValue(InputSettings.Movements axis)
	{
		return m_Movements[(int)axis].GetValue();
	}
	
	// Setter
	public bool UpdateAxis(float[] mouvements)
	{
		bool used = false;
		
		for(int i=0; i<m_Movements.Count; ++i)
		{
			float val = m_Movements[i].GetValue();
			if(Mathf.Abs(val) >= 0.7f)
			{
				used = true;
			}
			mouvements[i] = m_Movements[i].GetValue();
		}
		
		return used;
	}
	#endregion
	
	#region Actions
	// Getter
	public InputSettings.ActionStatus GetActionStatus(InputSettings.Actions actions)
	{
		InputSettings.ActionStatus result = InputSettings.ActionStatus.None;
		
		if(m_Actions[(int)actions].GetKeyDown())
		{
			result = InputSettings.ActionStatus.Down;
		}
		else if(m_Actions[(int)actions].GetKeyUp())
		{
			result = InputSettings.ActionStatus.Up;
		}
		else if(m_Actions[(int)actions].GetKeyPressed())
		{
			result = InputSettings.ActionStatus.Pressed;
		}
		else
		{
			result = InputSettings.ActionStatus.Released;
		}
		
		return result;
	}
	
	// Setter
	public bool UpdateActions(InputSettings.ActionStatus[] actions)
	{
		bool used = false;
		
		for(int i=0; i<m_Actions.Count; ++i)
		{
			Key curKey = m_Actions[i];
			
			if(curKey.GetKeyDown())
			{
				actions[i] = InputSettings.ActionStatus.Down;
				used = true;
			}
			else if(curKey.GetKeyUp())
			{
				actions[i] = InputSettings.ActionStatus.Up;
				used = true;
			}
			else if(curKey.GetKeyPressed())
			{
				actions[i] = InputSettings.ActionStatus.Pressed;
				used = true;
			}
			else
			{
				actions[i] = InputSettings.ActionStatus.Released;
			}
		}
		
		return used;
	}
	#endregion
	
	#region Menu inputs
	bool m_Up = false;
	bool m_Down = false;
	bool m_Left = false;
	bool m_Right = false;
	bool m_OK = false;
	bool m_Back = false;
	
	// Getter
	
	// Setter
	public bool UpdateMenuInputs(bool[] inputs)
	{
		bool used = false;
		
		// UP
		if(Input.GetKeyDown(KeyCode.UpArrow))
		{
			used = true;
			if(!m_Up)
			{
				inputs[(int)InputSettings.MenuInputs.Up] = true;
				m_Up = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.Up] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.Up] = false;
			m_Up = false;
		}
		
		// DOWN
		if(Input.GetKeyDown(KeyCode.DownArrow))
		{
			used = true;
			if(!m_Down)
			{
				inputs[(int)InputSettings.MenuInputs.Down] = true;
				m_Down = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.Down] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.Down] = false;
			m_Down = false;
		}
		
		// LEFT
		if(Input.GetKeyDown(KeyCode.LeftArrow))
		{
			used = true;
			if(!m_Left)
			{
				inputs[(int)InputSettings.MenuInputs.Left] = true;
				m_Left = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.Left] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.Left] = false;
			m_Left = false;
		}
		
		// RIGHT
		if(Input.GetKeyDown(KeyCode.RightArrow))
		{
			used = true;
			if(!m_Right)
			{
				inputs[(int)InputSettings.MenuInputs.Right] = true;
				m_Right = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.Right] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.Right] = false;
			m_Right = false;
		}
		
		// OK
		if(Input.GetKeyDown(KeyCode.Return))
		{
			used = true;
			Debug.Log("Enter pushed");
			if(!m_OK)
			{
				inputs[(int)InputSettings.MenuInputs.OK] = true;
				m_OK = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.OK] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.OK] = false;
			m_OK = false;
		}
		
		// BACK
		if(Input.GetKeyDown(KeyCode.Backspace))
		{
			used = true;
			if(!m_Back)
			{
				inputs[(int)InputSettings.MenuInputs.Back] = true;
				m_Back = true;
			}
			else
			{
				inputs[(int)InputSettings.MenuInputs.Back] = false;
			}
		}
		else
		{
			inputs[(int)InputSettings.MenuInputs.Back] = false;
			m_Back = false;
		}
		
		return used;
	}
	#endregion
}