using UnityEngine;
using System.Collections;
using System.Collections.Generic;

public class CameraMovements : MonoBehaviour 
{
    public List<MovableCameraZone> MovableZones;
    public List<FixedCameraZone> FixedZones;
    private CameraZone[] m_CameraZones;
    private int m_CurrentCameraZone;
	
	void Start()
	{
        m_CurrentCameraZone = -1;

        int size = 0;
        if (MovableZones != null)
        {
            size += MovableZones.Count;
        }
        if (FixedZones != null)
        {
            size += FixedZones.Count;
        }

        if (size > 0)
        {
            m_CameraZones = new CameraZone[size];
            int iterator = 0;

            if (MovableZones != null && MovableZones.Count > 0)
            {
                foreach (MovableCameraZone zone in MovableZones)
                {
                    m_CameraZones[iterator] = zone;
                    ++iterator;
                }
            }

            if (FixedZones != null && FixedZones.Count > 0)
            {
                foreach (FixedCameraZone zone in FixedZones)
                {
                    m_CameraZones[iterator] = zone;
                    ++iterator;
                }
            }
        }
	}
	
	void OnDrawGizmos()
	{
        if (MovableZones != null && MovableZones.Count > 0)
        {
            foreach (MovableCameraZone zone in MovableZones)
            {
                Color initColor = Gizmos.color;
                Gizmos.color = Color.green;
                Gizmos.DrawWireCube(zone.CharacterZone.Center, zone.CharacterZone.Size);
                Gizmos.color = Color.yellow;
                Gizmos.DrawWireCube(zone.CameraZone.Center, zone.CameraZone.Size);
                Gizmos.color = initColor;
            }
        }

        if (FixedZones != null && FixedZones.Count > 0)
        {
            foreach (FixedCameraZone zone in FixedZones)
            {
                Color initColor = Gizmos.color;
                Gizmos.color = Color.red;
                Gizmos.DrawWireCube(zone.CharacterZone.Center, zone.CharacterZone.Size);
                Gizmos.color = initColor;
            }
        }
	}

    public void HerosZone(Vector3 character)
	{
		if(m_CameraZones == null || m_CameraZones.Length == 0)
            return;

        // If the character is in the current zone
        if (m_CurrentCameraZone >= 0 && m_CurrentCameraZone < m_CameraZones.Length && m_CameraZones[m_CurrentCameraZone].CharacterZone.Contains(character))
        {
            // Just return the initial position
            //Debug.Log("Camera is in the zone");
            return;
        }
        else
        {
            // Search if the camera is in an other zone
            for (int i = 0; i < m_CameraZones.Length; ++i)
            {
                // If it is, update the current zone and return the initial position
                if (m_CameraZones[i].CharacterZone.Contains(character))
                {
                    m_CameraZones[i].SetCameraSettings();
                    m_CurrentCameraZone = i;
                    return;
                }
            }
        }
	}
}