﻿using UnityEngine;
using System.Collections;

public class StoryElement : Element
{
    public Element m_Source;
    public StoryEvent m_Story;

    protected override void OnEnable()
    {
        base.OnEnable();
        m_Active = false;
    }

    protected override void Start()
    {
    }

    public override bool UpdateElement()
    {
        if (!m_Active)
        {
            if (m_Source == null || m_Source.UpdateElement())
            {
                m_Story.StartStory();
                m_Active = true;
            }
            return false;
        }
        else return m_Story.IsFinished;
    }

    public override void Show()
    {
        m_Active = true;
    }

    public override void Hide()
    {
        m_Active = false;
    }

    public override void ReInit()
    {
        m_Active = false;
    }
}