﻿using UnityEngine;
using System.Collections;

public class Popup : InteractiveElement
{
    public Element[] m_Sources;
    public Texture2D[] m_Message;
    private int m_CurrentMessage;
    public Element m_ButtonOK;

    protected override void OnEnable()
    {
        m_CurrentMessage = 0;

        if (m_Sources.Length == 0) Show();
        else Hide();
    }

    public override bool UpdateElement()
    {
        if (!m_Active)
        {
            foreach (Element ie in m_Sources)
            {
                if (ie.UpdateElement())
                {
                    Show();
                }
            }
        }
        else
        {
            if (m_ButtonOK.UpdateElement())
            {
                m_CurrentMessage++;
                if (m_CurrentMessage < m_Message.Length)
                {
                    ShowMessage();
                }
                else
                {
                    Hide();
                    return true;
                }
            }
        }

        return false;
    }

    public override void Show()
    {
        base.Show();
        m_CurrentMessage = 0;
        ShowMessage();
        m_ButtonOK.Show();
    }

    public override void Hide()
    {
        base.Hide();
        m_ButtonOK.Hide();
    }

    private void ShowMessage()
    {
        if (m_CurrentMessage >= m_Message.Length)
            return;

        Debug.Log(m_Message[m_CurrentMessage]);
        renderer.material.SetTexture("_MainTex", m_Message[m_CurrentMessage]);
    }
}