﻿using UnityEngine;
using System.Collections;

public class Platform : InteractiveElement
{
    public Vector3 m_Movement;
    public float m_Size;
    public float m_Duration;
    public bool m_CanMove;
    public bool m_HaveToMove;
    public Transform m_PositionToMove;
    public float m_MoveDuration;

    private bool m_Rise;
    private bool m_Activated;
    private Transform m_Transform;
    private Vector3 m_InitialPosition;
    private Vector3 m_FinalPosition;
    private Vector3 m_DeltaMove;
    public Vector3 DeltaMove
    {
        get { return m_DeltaMove; }
    }
    private Timer m_Timer;

    private Vector3 m_RegisteredPosition;
    private bool m_RegisteredRise;
    private bool m_RegisteredActivated;

    protected override void OnEnable()
    {
        base.OnEnable();
    }

    protected override void Start()
    {
        base.Start();
        m_Timer = new Timer(m_Duration);
        m_Transform = transform;
        m_Rise = true;
        m_Activated = false;

        SaveStatus();
    }

    public override bool UpdateElement()
    {
        // Virus is using it
        if (m_Used)
        {
            if (m_Timer.IsLaunched)
            {
                if (!m_Timer.UpdateTime())
                {
                    m_DeltaMove = m_Transform.position;
                    m_Transform.position = Vector3.Lerp(m_InitialPosition, m_FinalPosition, m_Timer.GetHermiteProgress());
                    m_DeltaMove = m_Transform.position - m_DeltaMove;
                }
                else
                {
                    m_Trigger.InteractCharacter.CharacterOnPlatform(false, false, null);
                }
            }
            else if (!m_Trigger.IsIn)
            {
                m_Rise = !m_Rise;
                m_Transform.position = m_FinalPosition;
                m_Used = false;
                m_Activated = false;
            }
        }
        // Virus is not already in it
        else if(!m_Activated)
        {
            // The Virus is now in it
            if (m_Trigger.IsIn)
            {
                m_InitialPosition = m_Transform.position;
                if (m_Rise)
                {
                    m_FinalPosition = m_Transform.position + (m_Movement * m_Size);
                }
                else
                {
                    m_FinalPosition = m_Transform.position - (m_Movement * m_Size);
                }

                m_Activated = true;
                StartCoroutine("C_GoToMove");
            }
        }

        return false;
    }

    private IEnumerator C_GoToMove()
    {
        if (m_HaveToMove)
        {
            float timer = 0f;
            m_Trigger.InteractCharacter.MustGoSomewhere(m_PositionToMove.position, m_MoveDuration);

            while (timer < m_MoveDuration)
            {
                timer += Time.deltaTime;
                yield return 0;
            }
        }

        m_Trigger.InteractCharacter.CharacterOnPlatform(true, m_CanMove, this);
        m_Used = true;
        m_Timer.Restart();
    }

    public override void SaveStatus()
    {
        m_RegisteredPosition = m_Transform.position;
        m_RegisteredRise = m_Rise;
        m_RegisteredActivated = m_Activated;
    }

    public override void ReInit()
    {
        m_Transform.position = m_RegisteredPosition;
        m_Rise = m_RegisteredRise;
        m_Activated = m_RegisteredActivated;
    }
}